/***************************************************************************
                          stream.cpp  -  description
                             -------------------
    begin                : Tue Nov 9 1999
    copyright            : (C) 1999 by Martin Preuss
    email                : martin@aquamaniac.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


/*
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include <stdio.h>

#include "stream.h"


namespace HBCI {


/* AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 * StreamFilter_7bit
 * AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */


StreamFilter_7bit::StreamFilter_7bit(){
}


StreamFilter_7bit::~StreamFilter_7bit(){
}


void StreamFilter_7bit::encode(string &data){
    unsigned int pos;

    for (pos=0; pos<data.length(); pos++)
        data[pos]=data[pos] & 0x7f;
}


void StreamFilter_7bit::decode(string &data){
    encode(data);
}



/* AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 * stream
 * AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */



Stream::Stream(unsigned int buffersize){
    _inbuffer.erase();
    _outbuffer.erase();
    _totalread=0;
    _totalwritten=0;
    _inpos=0;
    _outpos=0;
    _eof=false;
    _linemode=STREAM_LINEMODE_UNIX;
    _timeout=STREAM_TIMEOUT;
    _buffersize=buffersize;
}


Stream::Stream(string inbuffer, string outbuffer){
    _inbuffer=inbuffer;
    _outbuffer=outbuffer;
    _inpos=0;
    _outpos=0;
    _totalread=0;
    _totalwritten=0;
    _eof=false;
    _linemode=STREAM_LINEMODE_DOS;
    _timeout=STREAM_TIMEOUT;
    if (!inbuffer.empty())
        _buffersize=_inbuffer.length();
    else
        _buffersize=_outbuffer.length();
}


Stream::~Stream(){
}


void Stream::_fillBuffer(){
    _totalread+=_inbuffer.length();
    _inpos=0;
    _getData(_inbuffer, _buffersize);
    if (_inbuffer.empty())
        _eof=true;
}


void Stream::_flushBuffer(){
    if (!_outbuffer.empty()) {
        _putData(_outbuffer);
        _totalwritten+=_outbuffer.length();
        _outbuffer.erase();
    }
}


void Stream::_getData(string &data, unsigned int size){
    list<StreamFilter*>::reverse_iterator iter;

    readData(data,size,_timeout);
    if (data.empty())
        return;
    for (iter=_filters.rbegin();
         iter!=_filters.rend();
         iter++)
        if ((*iter)->isActive())
            (*iter)->decode(data);
}


void Stream::_putData(string &data){
    list<StreamFilter*>::iterator iter;

    for (iter=_filters.begin(); iter!=_filters.end(); iter++)
        if ((*iter)->isActive())
            (*iter)->encode(data);
    writeData(data,_timeout);
}


int Stream::readChar(){
    if (_eof)
        return -1;
    if (_inpos>=_inbuffer.length()) {
        _fillBuffer();
        if (_eof)
            return -1;
    }
    return ((_inbuffer.at(_inpos++)) & 0xff);
}


int Stream::peekChar(){
    int c;

    c=readChar();
    if (c!=-1)
        _inpos--;
    return c;
}


bool Stream::eof() {
    peekChar();
    return _eof;
}


void Stream::writeChar(char c){
    if (_outbuffer.length()>=_buffersize)
        _flushBuffer();
    _outbuffer+=c;
}


void Stream::readRaw(string &data, unsigned int size){
    unsigned int s2;
    
    if (_inpos>=_inbuffer.length()) {
        _inbuffer.erase();
        _inpos=0;
    }

    if (!_inbuffer.empty()) {
        s2=_inbuffer.length()-_inpos;
        s2=(size<s2)?size:s2;
        data=_inbuffer.substr(_inpos,s2);
        _inpos+=s2;
    }
    else
        _getData(data, size);
}


void Stream::writeRaw(string &s){
    if (!_outbuffer.empty())
        _flushBuffer();
    _putData(s);
}


bool Stream::readRawForced(string &data, unsigned int size){
    string localdata;

    while(size) {
        readRaw(localdata,size);
        if (localdata.empty())
            return false;
        size-=localdata.length();
        data+=localdata;
        localdata.erase();
    }
    return true;
}


void Stream::insertFilter(StreamFilter *f){
    _filters.push_front(f);
}


void Stream::appendFilter(StreamFilter *f){
    _filters.push_back(f);
}


void Stream::readLine(string &data, unsigned int linesize){
    int c;
    
    while(linesize--) {
        c=readChar();
        if (c==-1)
            return;
        else if (c==STREAM_LF)
            return;
        else if (c==STREAM_CR) {
            if (_linemode!=STREAM_LINEMODE_DOS)
                data+=(char)(c & 0xff);
        }
        else
            data+=(char) (c & 0xff);
    }
}


void Stream::writeString(string s){
    unsigned int pos;

    for (pos=0; pos<s.length(); pos++)
        writeChar(s.at(pos));
}


void Stream::writeLine(string s){
    writeString(s);
    if (_linemode==STREAM_LINEMODE_DOS)
        writeChar(STREAM_CR);
    writeChar(STREAM_LF);
}


void Stream::flushBuffer(){
    _flushBuffer();
}


unsigned int Stream::readPos(){
    return _totalread+_inpos;
}


unsigned int Stream::writePos(){
    return _totalwritten+_outpos;
}

} // namespace HBCI
