//
// safequote.pike
//
// This module evolved from the Encode Unsafe HTML module by Karl
// Stevens <karl@maxim.ca>. It's no longer a provider module, but
// implements a tag <safequote data=""> which converts all but
// the listed legal HTML tags inside the 'data' parameter into
// &lt;&gt; constructs.
//
// Petter E. Stokke <gibreel@nettstudio.no>
//
// $Log: safequote.pike,v $
// Revision 1.7  2001/01/15 13:39:53  gibreel
// Oops, forgot a little thing.
//
// Revision 1.6  2001/01/15 11:09:06  gibreel
// Updated the comments to reflect the change...
//
// Revision 1.5  2001/01/15 11:04:58  gibreel
// Reimplemented this tag as a non-container tag accepting the parameter DATA
// with the text to be quoted, after discussing security problems with Karl
// Stevens, the author of the module upon which this is based.
//
// Revision 1.4  2001/01/03 16:29:35  gibreel
// Cleaned up the code a little for distribution.
//

string cvs_version = "$Id: safequote.pike,v 1.7 2001/01/15 13:39:53 gibreel Exp $";

int thread_safe=1;

#include <module.h>
inherit "module";
 inherit "roxenlib";

 
mapping tags;
mapping containers;


array register_module();


void makecontainermap() {
  containers=([]);

  foreach(QUERY(allowedcontainers), string t) {
    containers+=([t:safe_container]);
  }
  return;
}

void maketagmap() {
  tags=([]);

  foreach(QUERY(allowedtags), string t) {
    tags+=([t:safe_tag]);
  }
  return;
}

string encode_unsafe_tags( string contents) {

    string result;

    contents = replace(contents,({"{","}"}),({"<",">"}));

    result = parse_html(contents, tags, containers);

    return replace(result,({"<",">","{","}"}),({"&lt;","&gt;","<",">"}));
}

string print_safe_tags() {
  string result="";

  foreach(QUERY(allowedtags)+QUERY(allowedcontainers),string t) {
    result+="&lt;"+t+"&gt; ";
  }
  return result;

}

string safe_tag( string tag, mapping m, object id) {
    string q=make_tag_attributes(m);
    //string q="",*foo = indices(m);
    //int i;
    //for (i=0;i<sizeof(foo);i++)
    //q += foo[i]+" "+m[foo[i]];
    return "{"+tag+(strlen(q)?" "+q:"")+"}";
}
string safe_container( string tag, mapping m,
                       string contents, object id) {
  return safe_tag(tag,m,id)+contents+"{/"+tag+"}";
}

string query_provides() {
  return "killtags";
}

void start() {
  makecontainermap();
  maketagmap();
}

void|string check_variable (string name, mixed v) {
  if(name=="allowedtags")
    maketagmap();
  if(name=="allowedcontainers")
    makecontainermap();

  return;
}

string tag_safequote(string tag, mapping m, object request_id ) 
{ 
    object re;
    if(m->help) // This is a standard argument.
	return register_module()[2];
    if (m->data)
	return encode_unsafe_tags(m->data);
    return "";
}

void create() {
  set_module_creator("Petter E. Stokke (gibreel@nettstudio.no)");

  defvar( "allowedtags", ({"li","dt","dd","br","hr"}),
          "Allowed HTML Tags",
          TYPE_STRING_LIST,
	  "This is a list of tags that are allowed in the embedded "
	  "HTML.  Everything else will be HTML-escaped." );

  defvar( "allowedcontainers", ({"a","p","b","i","div"}),
          "Allowed HTML Containers",
          TYPE_STRING_LIST,
	  "This is a list of containers that are allowed in the embedded "
	  "HTML.  Everything else will be HTML-escaped." );
}

array register_module()
{
  return ({ MODULE_PARSER, 
            "Safe HTML tag",
            ("A tag &lt;SAFEQUOTE&gt; which strips away all HTML/RXML tags except simple text styling tags and links from what is given as the DATA parameter.<p>Mostly uses code from the <a href=\"http://www.northsun.net/killtags.html\">encode unsafe HTML</a> module by Karl Stevens."),
            0, 1	     
            });
}
 
mapping query_tag_callers() { return (["safequote":tag_safequote,]); }
 
