////////////////////////////////////////////////////////////////////////
// s11nlite.cpp: impl file for s11nlite.h
// author: stephan@s11n.net
// license: public domain
////////////////////////////////////////////////////////////////////////
#include "s11nlite.h"

namespace s11nlite {

        namespace sharing {
                struct sharing_context {};
        }

        /**
           Class name of current Serializer.
        */
        std::string m_serializer = ::classname<default_serializer_type>();

        void serializer_class( const std::string & c )
        {
                m_serializer = c;
        }

        std::string serializer_class()
        {
                return m_serializer;
        }

        serializer_base_type *
        create_serializer( const std::string & classname )
        {
                serializer_base_type * s =
                        S11N_NS::classload<serializer_base_type>( classname );
                //CERR << "create_serializer("<<classname<<") = " << std::hex<<s <<"\n";
                return s;
        }

        serializer_base_type * create_serializer()
        {
                return create_serializer( m_serializer );
        }


        node_type *
        find_child( node_type & parent,
                    const std::string subnodename )
        {
                return S11N_NS::find_child_by_name( parent, subnodename );
        }

        const node_type *
        find_child( const node_type & parent,
                    const std::string subnodename )
        {
                return S11N_NS::find_child_by_name( parent, subnodename );
        }

        bool save( const node_type & src, std::ostream & dest )
        {
                typedef std::auto_ptr<serializer_base_type> AP;
                AP s = AP(create_serializer());
                if( ! s.get() ) return false;
                return s.get()->serialize( src, dest );
        }


        bool save( const node_type & src, const std::string & filename )
        {
                typedef std::auto_ptr<serializer_base_type> AP;
                AP s = AP(create_serializer());
                if( ! s.get() ) return false;
                return s.get()->serialize( src, filename );
        }

        node_type * load_node( const std::string & src )
        {
                return S11N_NS::io::load_node<node_type>( src );
        }

        node_type * load_node( std::istream & src )
        {
                return S11N_NS::io::load_node<node_type>( src );
        }


} // namespace
