# This is out-moded. Don't use it.
#
# manages moc file dependencies and compiling for Qt moc sources.
#
# Usage:
# include $(TOC_MAKESDIR)/qt_moc.make
#
# Effects:
# - moc_*.* are managed for you (deps, compiling
# - $(EXTRA_OBJECTS) has the moc object files added to it. This is so
#   cpp_*_lib.make will link these in.


MOC_DEPSFILE = .deps.moc.make

MOC_HEADERS = $(shell grep -l "Q_OBJECT" *.h /dev/null) # this is only a half-baked check!

MOC_BASENAMES = $(patsubst %.h,%,$(MOC_HEADERS))
MOC_OUT_SOURCES = $(patsubst %,moc_%.cpp,$(MOC_BASENAMES))
MOC_OBJECTS = $(patsubst %.cpp,%.o,$(MOC_OUT_SOURCES))

EXTRA_OBJECTS += $(MOC_OBJECTS) # EXTRA_OBJECTS is used by cpp_{dynamic,static}_lib.make

CLEAN_FILES += $(MOC_OUT_SOURCES) $(MOC_DEPSFILE)

$(MOC_OUT_SOURCES):
	@in=$@; in=$${in%%.cpp}.h; in=$${in##moc_}; \
	echo $(MOC) $$in -o $@; $(MOC) $$in -o $@;


# deps: mocdeps

mocdeps: $(MOC_DEPSFILE)
$(MOC_DEPSFILE): $(wildcard *.h)
	@echo "Generating moc file dependencies..."
	@echo '# auto-generated. do not edit' > $(MOC_DEPSFILE)
	@for m in $(MOC_BASENAMES); do \
		echo "moc_$${m}.cpp: $$m.h" >> $(MOC_DEPSFILE); \
		echo "moc_$${m}.o: moc_$${m}.cpp" >> $(MOC_DEPSFILE); \
	done


mocs: mocdeps

all: mocs
