/*!
  \file    DBMSrvProc_ServerProcessCommandLineConverter.cpp
  \author  MarcW
  \brief   server process command line converter implementation

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (C) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "heo01.h"

#include "DBM/Srv/Process/DBMSrvProc_ServerProcessCommandLineConverter.hpp"

#if defined (_WIN32)
  #define PATH_DELI "\\"
  #define PATH_TUEDDELCHEN "\""
#else
  #define PATH_DELI "/"
  #define PATH_TUEDDELCHEN ""
#endif

DBMSrvProc_ServerProcessCommandLineConverter::DBMSrvProc_ServerProcessCommandLineConverter(
        const char* aCommandLine)
        : m_IsValid(false),
          m_ProgramIndex(-1),
          m_ConvertedCommandLine(NULL) {

    // analyze index
    m_ProgramIndex = atoi(aCommandLine)-1;

    // check array range
    if( (m_ProgramIndex < 0) || (m_ProgramIndex >= (KeyInvalidEntry - 1)) )
        return;

    // check array entry
    if( m_ProgramIndex != (m_Programs[m_ProgramIndex].nKey - 1)) 
        return;

    // retrieve direcetory
    tsp00_Pathc    szDirectory;
    tsp01_RteError aRteError;
    switch (m_Programs[m_ProgramIndex].nDir){
      case DirIndepBin:
        if(!sqlGetIndependentBinPath(szDirectory, TERM_WITH_DELIMITER_EO01, &aRteError)) {
          szDirectory.Init();
        } // end if
        break;
      default:
        szDirectory.Init();
        break;
    } // end switch

    // skip program index
    const char* programArguments = strchr(aCommandLine, ' ');
    programArguments++;
    if( programArguments > aCommandLine + strlen(aCommandLine))
        return;

    // allocate memory
    m_ConvertedCommandLine = new char[
                strlen(szDirectory) +
                strlen(m_Programs[m_ProgramIndex].szProgram) +
                strlen(programArguments) +
                4]; // Tueddelchen + Tueddelchen + Space + Nullbyte
    // check memory
    if( m_ConvertedCommandLine == NULL )
        return;

    // generate command
    sprintf(m_ConvertedCommandLine,
                "%s%s%s%s %s",
                PATH_TUEDDELCHEN,
                szDirectory.asCharp(),
                m_Programs[m_ProgramIndex].szProgram,
                PATH_TUEDDELCHEN,
                programArguments);
    // constructor completed sucessfull
    m_IsValid = true;
}

DBMSrvProc_ServerProcessCommandLineConverter::~DBMSrvProc_ServerProcessCommandLineConverter() {
    if( m_ConvertedCommandLine != NULL )
        delete[] m_ConvertedCommandLine;
}

// these strings may not contain spaces...
// when adding a new string, don't forget to increment array (also in header file)
DBMSrvProc_ServerProcessCommandLineConverter::Programs DBMSrvProc_ServerProcessCommandLineConverter::m_Programs[] = {
// nKey                       bPipe  nDir         szProgram
  {KeySchedulerProgram,       false, DirNothing,  "pgm"PATH_DELI"dbmsrvscd"},
  {KeyEventDispatcherProgram, true,  DirNothing,  "dbmevtdisp"             },
  {KeyDbanalyzer,             true,  DirIndepBin, "dbanalyzer"             },
  {KeyInvalidEntry,           false, DirUnknown,  ""                       }};
