--TEST--
maxdb select into
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
include "connect.inc";

/*** test maxdb_connect 127.0.0.1 ***/
$link = maxdb_connect("localhost", $user, $passwd);

/* check connection */
if (!$link) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}
   
/* Performing SQL query */
$stmt = maxdb_prepare ($link, "SELECT name INTO ? FROM hotel.city where zip = ?");
if (!$stmt) {
  printf ("Prepare failed: %s\n", maxdb_error($link));
}

$name = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
$zip = "48226";
maxdb_stmt_bind_param($stmt, 'ss', $name, $zip);
maxdb_stmt_execute($stmt);

printf ("%s\n", $name);

maxdb_stmt_close ($stmt);

/* Performing SQL query */
$stmt = maxdb_prepare ($link, "SELECT cno INTO ? FROM hotel.customer where name = ?");
if (!$stmt) {
  printf ("Prepare failed: %s\n", maxdb_error($link));
}

$name = "Baker";

maxdb_stmt_bind_param($stmt, 'ds', $cno, $name);
maxdb_stmt_execute($stmt);

printf ("%d\n", $cno);

maxdb_stmt_close ($stmt);

/* Performing SQL query */
$stmt = maxdb_prepare ($link, "SELECT price INTO ? FROM hotel.room where hno = ? and type = ?");
if (!$stmt) {
  printf ("Prepare failed: %s\n", maxdb_error($link));
}

$hno = "50";
$rtype = "suite";

maxdb_stmt_bind_param($stmt, 'dss', $price, $hno, $rtype);
maxdb_stmt_execute($stmt);

printf ("%f\n", $price);

maxdb_stmt_close ($stmt);
?>
--EXPECT--
Detroit
4100
500.000000



