/*!
  @file           SQLDBC_IProxyRuntime
  @author         D039759
  @ingroup        SQLDBC
  @brief          Interface to the proxy runtime environment.
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/
#ifndef SQLDBC_IPROXYRUNTIME_H
#define SQLDBC_IPROXYRUNTIME_H

#include "Interfaces/SQLDBC/SQLDBC_IRuntime.h"

class SQLDBC_IProxyRuntime
    : public SQLDBC_IRuntime
{
public:
    virtual ~SQLDBC_IProxyRuntime() {}
    
    virtual SAPDB_Bool getChallenge(const char *servernode,
                                    const char *serverdb,
                                    SAPDB_Int8&    sessionid,
                                    char          *challenge,
                                    SQLDBC_Length& challengeLength,
                                    char          *errortext,
                                    SQLDBC_Length  errortextLength)=0;

};
 

#endif
   
