/*!
  @file           SQLDBC_ProxyRuntime
  @author         D039759
  @ingroup        SQLDBC
  @brief          Internal runtime for proxy challenge-response. 
  @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/
#ifndef SQLDBC_PROXYRUNTIME_H
#define SQLDBC_PROXYRUNTIME_H

#include "Interfaces/SQLDBC/SQLDBC.h"
#include "Interfaces/SQLDBC/SQLDBC_ClientRuntime.h"
#include "Interfaces/SQLDBC/SQLDBC_IProxyRuntime.h"
#include "Interfaces/SQLDBC/SQLDBC_Proxy.h"

class SQLDBC_ProxyRuntime
    : public SQLDBC_ClientRuntime, public SQLDBC_IProxyRuntime
{
public:
    SQLDBC_DLLEXPORT SQLDBC_ProxyRuntime();
    SQLDBC_DLLEXPORT ~SQLDBC_ProxyRuntime();
    
    // inherited stuff that must be overridden due to ambigiousity
    virtual const char *getIdentfier() const;
    virtual SAPDB_Bool checkKeyOption(const char *keyoption,
                                      char *servernode,
                                      SAPDB_Int4& servernodelength,
                                      char *serverdb,
                                      SAPDB_Int4& serverdblength,
                                      SAPDB_Int4& isolationlevel,
                                      SAPDB_Int4& cachelimit,
                                      SAPDB_Int4& sqlmode,
                                      SAPDB_Int4& timeout,
                                      char *username,
                                      SAPDB_Int4& usernamelength,
                                      SQLDBC_StringEncoding& usernameEncoding,
                                      Msg_List& errorMessages);
    virtual SAPDBMem_IRawAllocator& getGlobalAllocator() ;
    virtual SAPDB_Bool getSession(const char *connectUrl,
                                  const char *connectCommand,
                                  const char *password,
                                  SAPDB_Int4  passwordLength,
                                  const SQLDBC_StringEncoding commandEncoding,
                                  SAPDB_Int8&  sessionID,
                                  SAPDB_UInt4& packetSize,
                                  SAPDB_Int4& packetListSize,
                                  void **packetList,  
                                  void **sessionInfoReply,
                                  Msg_List& errorMessages,
                                  SAPDBMem_IRawAllocator* allocator = 0);
    virtual SAPDB_Bool releaseSession(SAPDB_Int8 sessionID,
                                      Msg_List& errorMessages);
    virtual SAPDB_Bool request(SAPDB_Int8  sessionID,
                               void       *requestData,
                               SAPDB_UInt4 requestDataLength,
                               Msg_List& errorMessages); 
    virtual SAPDB_Bool receive(SAPDB_Int8 sessionID,
                               void **replyData,
                               SAPDB_Int4& replyDataLength,
                               Msg_List& errorMessages);
    virtual SAPDB_Bool cancelCurrentCommand(SAPDB_Int8 sessionID,
                                            Msg_List& errorMessages);
    virtual SAPDB_Bool createMutex(MutexHandle& mutexHandle, 
                                   SAPDBMem_IRawAllocator& allocator,
                                   Msg_List& errorMessages);
    virtual SAPDB_Bool lockMutex(MutexHandle mutexHandle);
    virtual SAPDB_Bool releaseMutex(MutexHandle mutexHandle);
    virtual SAPDB_Bool destroyMutex(MutexHandle& mutexHandle, 
                                    SAPDBMem_IRawAllocator& allocator,
                                    Msg_List& errorMessages);
    virtual SAPDB_Bool  createCounter(CounterHandle& counterHandle,
                                      SAPDBMem_IRawAllocator& allocator,
                                      Msg_List& errorMessages);
    virtual SAPDB_UInt4 nextCounter(CounterHandle counterHandle);
    virtual SAPDB_Bool  destroyCounter(CounterHandle counterHandle,
                                      SAPDBMem_IRawAllocator& allocator,
                                      Msg_List& errorMessages);
    virtual TaskID getCurrentTaskID();                                      
    virtual SAPDB_Bool createSemaphore(SemaphoreHandle& semaphoreHandle,
                                       SAPDB_Int4 initialValue,
                                       SAPDBMem_IRawAllocator& allocator,
                                       Msg_List& errorMessages);
    virtual SAPDB_Bool waitSemaphore(SemaphoreHandle semaphoreHandle);
    virtual SAPDB_Bool signalSemaphore(SemaphoreHandle semaphoreHandle);
    virtual SAPDB_Bool destroySemaphore(SemaphoreHandle& semaphoreHandle,
                                        SAPDBMem_IRawAllocator& allocator,
                                        Msg_List& errorMessages);
    virtual TaskTraceContext* getTaskTraceContext();
    virtual void getFlags(char *flags);
    virtual void addTraceFlags(unsigned int flags);
    virtual void removeTraceFlags(unsigned int flags);
    virtual void write(const char *s, SAPDB_Int4 size);
    virtual void writeln(const char *s, SAPDB_Int4 size);
    
    // new methods
    SQLDBC_DLLEXPORT SAPDB_Bool getChallenge(const char *servernode,
                                             const char *serverdb,
                                             SAPDB_Int8&    sessionid,
                                             char          *challenge,
                                             SQLDBC_Length& challengeLength,
                                             char          *errortext,
                                             SQLDBC_Length  errortextLength);
                                             
    struct SessionInfo
    {
        SAPDB_Int8   sessionid;       
        SAPDB_UInt4  packetsize;
        SAPDB_Int4   packetlistsize;
        void        *packetlist[2];
    };

private:
    SAPDB_Bool getChallenge(const char    *connectURL,
                            SAPDB_Int8&    sessionid,
                            char          *challenge,
                            SQLDBC_Length& challengeLength,
                            Msg_List& errorMessages,
                            SAPDBMem_IRawAllocator* allocator);
    
    SessionInfo *acquireSessionInfo();
    SessionInfo *getSessionInfo(SAPDB_Int8 sessionid);
    void releaseSessionInfo(SessionInfo*);
    
    SQLDBC_IRuntime::MutexHandle pendingSessionsMutex; 
    SAPDB_Int4  pendingSessionsCount;
    SessionInfo pendingSessions[256];
};



#endif
