/*!
  @file           RTE_UNIXAuthenticate.h
  @author         JoergM
  @brief          DBM RunTime: User Authentification

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/
#ifndef RTE_UNIXAUTHENTICATE_H
#define RTE_UNIXAUTHENTICATE_H

#include "RunTime/RTE_Types.h"

/*! @brief Retrieve UNIX user id of SdbOwner

    @return   @param username [in] user name
    @param sdbOwnerUserId [out] corresponding sdb owner user id
    @return true if call succeeded, false if failed
 */
SAPDB_Bool
RTE_GetSapdbOwnerUserId(SAPDB_Int4 VAR_VALUE_REF sdbOwnerUserId);

#endif /* RTE_UNIXAUTHENTICATE_H */
