/* @lastChanged: "1998-05-08  8:28"
 *
 * @filename:   hin28.h
 * @purpose:    "Exports for SQL package handling"
 * @release:    7.1.0.0
 * @see:        ""
 *
 * @copyright:  (c) 1997-2004 SAP AG"



    ========== licence begin  GPL
    Copyright (c) 1997-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 */

#ifndef HIN28_H
#define HIN28_H

#include "vsp001.h"
#include "vsp0031.h"
#include "gin01.h"

#if defined (__cplusplus)
extern "C" {
#endif
/* ------------------------------- */
/* specification public functions */
/* ------------------------------- */
int i28utilbackupcmd (
     tin01_sql_session       * pSession,
     tin01_c_sqlca           * pSqlca,
     boolean                 * bBackupRC,
     boolean                   bBackupState,
     tin01_cstr                cmd,
     ... );

int i28utilbackuprequest (
     tin01_sql_session       * pSession,
     boolean                   bBackupState,
     tin01_cstr                cmd );

int i28utilbackupreceive (
     tin01_sql_session       * pSession,
     tin01_c_sqlca           * pSqlca,
     boolean                 * bBackupRC,
     ... );

int i28utildiagtocmd (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd,
     long                    * nPageSize,
     void                   ** pPageBuf );

int i28utildiagrestcmd (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd,
     long                      nPageSize,
     const void              * pPageBuf );

void i28errmsg (
     tin01_sql_session       * pSession,
     tsp00_C256c             * errbuf);

void i28initsession (
    tin01_sql_session       * pSession,
    tsp1_packet             * pPacket);

void i28pascalstring (
     char                    * target,
     int                       targetlen,
     const char              * source,
     int                       sourcelen );

tin01_sql_session * i28lasterr_on (
     tin01_sql_session       * pSession );

int i28specialconnect (
      tin01_sql_session      * pSession );

int i28eventconnect (
      tin01_sql_session      * pSession );

int
i28eventwait (
      tin01_sql_session       * pSession,
      tsp31_event_description * event);

void i28sqllasterr (
      tin01_sql_session      * pSession,
      tsp00_ErrTextc         * errtext,
      tsp00_KnlIdentifierc   * errname,
      tsp00_Int2             * errcode,
      tsp00_Int2             * errpos );

void i28specialrelease (
      tin01_sql_session      * pSession );

#define i28eventrelease i28specialrelease

int i28utility (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd );

void i28release (
      tin01_sql_session      * pSession,
      tin01_bool               bWithCommit );

int i28sqlconnect (
      tin01_sql_session      * pSession );

int i28fetchnice (
     tin01_sql_session       * pSession,
     char                    * pResult,
     long                      nResultLen);

int i28selectnice (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd,
     char                    * pResult,
     long                      nResultLen,
     bool                      bOneRowResult,
     bool                      bDesc,
	 bool                      bDataOnly);

int i28selectinfo (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd,
     char                    * pResult,
     char                      cFieldSep );

int i28fetch (
     tin01_sql_session       * pSession,
     char                    * pResult,
     long                      nResultLen,
     char                      cFieldSep,
     char                      cStringDel,
     char                      cRecSep );

int i28select (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd,
     char                    * pResult,
     long                      nResultLen,
     char                      cFieldSep,
     char                      cStringDel,
     char                      cRecSep );

int i28record (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd);

int i28nextrecord (
     tin01_sql_session       * pSession);

int i28fieldvalue (
     tin01_sql_session       * pSession,
     const tsp00_Int4          nField,
     tin01_c_hostvar         * pHostvar,
     const char                cStringQuote);

int i28adbs (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd );

int i28adbs_noinfo (
    tin01_sql_session * session,
    tin01_cstr cmd,
    bool withCommit);

int i28adbsf (
     tin01_sql_session       * pSession,
     tin01_cstr                cmd,
     ...);

int i28utilcmd (
     tin01_sql_session       * pSession,
     tin01_c_sqlca           * pSqlca,
     tin01_cstr                cmd,
     ... );

int i28replyavailable (
     tin01_sql_session       * pSession );

void i28cancel (
     tin01_sql_session       * pSession );

int i28sqlcmd (
     tin01_sql_session       * pSession,
     tin01_c_sqlca           * pSqlca,
     tin01_cstr                cmd,
     ... );

int i28fetchcmd (
     tin01_sql_session       * pSession,
     tin01_cstr              cmd,
     int                     vars);

int
i28switch (
    tin01_sql_session        * session,
    tin01_cstr               trace,
    tin01_cstr               test);

int
i28switchlimit (
    tin01_sql_session        * session,
    tin01_cstr               trace,
    tin01_cstr               test,
    tin01_cstr               start,
    tin01_cstr               stop,
    int                      limit);

int
i28buflimit (
    tin01_sql_session        * session,
    int                      limit);

int
i28minbuf (
    tin01_sql_session        * session);

int
i28maxbuf (
    tin01_sql_session        * session);

void
i28initparse (
    tin01_sql_session * session);

void
i28initadbs (
    tin01_sql_session * session);

void
i28initprocreply (
    tin01_sql_session * session);

void
i28seterrorinfo  (
    tin01_sql_session * session,
    int                 errorCode,
    const char *        errorMessage,
    int                 messageLen);

void
i28pcmd (
    tin01_sql_session * session,
    tin01_cstr cmd,
    int len);

void
i28pcmdf (
    tin01_sql_session * session,
    tin01_cstr cmd,
    ...);

int
i28sql (
    tin01_sql_session * session,
    tin01_sqlresult * sqlresult);

void
i28gparseid (
    tin01_sql_session * session,
    tin01_parseid pid);

tsp00_Int4
i28resultcount (
    tin01_sql_session * session);

int
i28paramcount (
    tin01_sql_session * session);

tsp1_param_info *
i28gparaminfo (
    tin01_sql_session * session,
    int i);

void
i28initexecute (
    tin01_sql_session * session,
    tin01_parseid pid);

void
i28initspecial (
    tin01_sql_session * session,
    tsp1_cmd_mess_type_Param messType);

int
i28droppid (
    tin01_sql_session * session,
    tin01_parseid pid);

tin01_byte           *
i28argaddr (
    tin01_sql_session * session,
    tsp00_Int4 bufpos);

tin01_bool
i28findpart (
    tin01_sql_session * session,
    tsp1_part_kind_Param requiredKind);

int
i28parg (
    tin01_sql_session * session,
    const tin01_byte * arg,
    int varlen,  /* in bytes */
    int sqllen,  /* in bytes */
    tsp00_Int4 bufpos,
    char defByte);

int
i28putUCS2 (
    tin01_sql_session * session,
    const tin01_byte * arg,
    const tsp77encoding * srcEncoding,
    int varlen,  /* in bytes */
    int sqllen,  /* in bytes */
    tsp00_Int4 bufpos);

void
i28pnull (
    tin01_sql_session * session,
    int sqllen,
    tsp00_Int4 bufpos);

tsp1_part      *
i28newpart (
    tin01_sql_session * session,
    tsp1_part_kind_Enum partKind);

tin01_bool
i28gresulttablename (
    tin01_sql_session * session,
    int              * len,
    char             * resulttablename);

tsp00_Int4
i28partlen (
    tin01_sql_session * session);

void
i28addpartdata (
    tin01_sql_session * session,
    const void *data,
    int len);

char           *
i28getpart (
    tin01_sql_session * session);

char           *
i28argsbuf (
    tin01_sql_session * session);

tsp00_Int4
i28nameslen (
    tin01_sql_session * session);

tin01_cstr
i28colnames (
    tin01_sql_session * session);

void
i28extendpart (
    tin01_sql_session * session,
    int lendiff);

void
i28getFreePartInfo (
    tin01_sql_session * session,
    void ** dataptr,
    int   * bufPos,
    int   * freeLen);

int
i28requestForPython (
    tin01_sql_session * session,
    tin01_sqlresult * sqlresult);
int
i28receiveForPython (
    tin01_sql_session * session,
    tin01_sqlresult * sqlresult);

int i28connect (
    tin01_sql_session * session);

#if defined (__cplusplus)
}
#endif

#endif
