/*!***************************************************************************

  module      : gbd490.h

  -------------------------------------------------------------------------

  author      : TorstenS
  responsible : UweH

  special area: CreateIndexCoordinator
  description : 


  last changed: 1999-07-21  14:00
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 1999-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/



#ifndef GBD490_H
#define GBD490_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

                     // Content of include files

#include "gsp00.h"   // PASCAL: SP_basic_constants_and_types
#include "ggg00.h"   // PASCAL: GG_kernel_constants_and_types
#include "gbd00.h"   // PASCAL: BD_kernel_constants_and_types
#include "gbd494.h"  // CPP   : FunnelHandling
#include "gbd496.h"  // CPP   : FileHandling
#include "gbd497.h"  // CPP   : StackDescInfo


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  FORWARD DECLARATION                                                      *
 *===========================================================================*/


/*===========================================================================*
 *  GLOBAL FUNCTIONS (CODE)                                                  *
 *===========================================================================*/

externCpp void
bd490InitIndexCounter (tgg00_IndexCounter  &IndexCounter);

/*---------------------------------------------------------------------------*/

inline void
bd490Inc (tsp00_Int4   &BaseCounter,
          tsp00_Int4   AddCounter)
{
    if (MAX_INT4_SP00 > (BaseCounter + AddCounter)) BaseCounter += AddCounter;
}

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

class cbd490_CreateIndexParallel
{
public:

    cbd490_CreateIndexParallel (
        cbd494_SortableInvTree  &InvTree,
        tbd_current_tree        &PrimCurrent,
        tgg00_StackDesc         &StackDesc,
		tgg00_IndexCounter      &IndexCounter,
		tgg00_IndexMode			IndexMode);
    
    ~cbd490_CreateIndexParallel ();
    

    void bd490BuildIndex ();

private:
    
    void bd490_ProcessKeyRangeByCoordinator (
        tsp00_Int4       CurrFileIndex,
        tsp00_Int4       NumLeavesToScan,
        tsp00_Int4       AvgRecordsPerLeaf,
        tsp00_BytePtr    pStartPrimKey,
        tsp00_Int4       StartPrimKeyLen,
        tsp00_BytePtr    pStopPrimKey,
        tsp00_Int4       StopPrimKeyLen,
        tsp00_Int4      &RetryCount,
        tgg00_FileId    &QueueId,
        tsp00_PageNo     PrimQueuePno,
        tsp00_PageNo     SecQueuePno
        );
    
    void bd490_SendKeyRangeToServer (
        tsp00_Int4       CurrFileNo,
        tsp00_Int4       NumLeavesToScan,
        tsp00_Int4       AvgRecordsPerLeaf,
        tsp00_BytePtr    pStartPrimKey,
        tsp00_Int4       StartPrimKeyLen,
        tsp00_BytePtr    pStopPrimKey,
        tsp00_Int4       StopPrimKeyLen,
        tsp00_Int4      &NumSendOrders,
        tsp00_Int4      &RetryCount,
        tgg00_FileId    &TempFileId,
		tsp00_PageNo     PrimQueuePno,
		tsp00_PageNo     SecQueuePno
        );

    void bd490_TaskAbortHandling (
        tsp00_Int4 &NumSendOrders
        );
	
    void bd490_WaitForReply (
        tsp00_Bool   bNoMorePrimData,
        tsp00_Int4  &NumSendOrders
        );
	
private:

    tgg00_BasisError        &m_TrError;
    tgg00_TransContext      &m_Trans;
    tbd_current_tree        &m_PrimCurrent;
	tgg00_IndexCounter      &m_IndexCounter; 
    /* */
    tgg00_IndexMode         m_IndexMode;
    tsp00_Int4              m_NumUsableServerTasks;
    cbd497_StackDescInfo	m_Stack;
    cbd496_FileHandling     m_FileList;
};

/*---------------------------------------------------------------------------*/

class cbd490_CreateIndexSequential
{
public:

    cbd490_CreateIndexSequential (
        cbd300_InvCurrent       &InvCurrent,
        tbd_current_tree        &PrimCurrent,
        tgg00_StackDesc         &StackDesc,
		tgg00_IndexCounter      &IndexCounter,
		tgg00_IndexMode			IndexMode);
    
    ~cbd490_CreateIndexSequential ();
    

    void bd490BuildIndex ();

private:

    tgg00_BasisError        &m_TrError;
    tgg00_TransContext      &m_Trans;
    cbd300_InvCurrent       &m_InvCurrent;
    tbd_current_tree        &m_PrimCurrent;
	tgg00_IndexCounter      &m_IndexCounter; 
    /* */
    tgg00_IndexMode         m_IndexMode;
    cbd497_StackDescInfo	m_Stack;
};

/*===========================================================================*
 *  DEFINITION OF METHODS                                                    *
 *===========================================================================*/

#endif  /* GBD490_H */

 
 

 
