/*!******************************************************************************

  @file         hbd17.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        filedirectory

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD17_H
#define HBD17_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xee\x4b\xd5\x82\x0e\x36\x5c\x12\x79\x7d\x5e\x1b\x16\x41\x17\x6b'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void b17add_fdir (
    tgg00_Filename        &  fn,
    tbd_fileinfo          &  fi,
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17create_fdir (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17del_fdir (
    tgg00_Filename        &  fn,
    tbd_fileinfo          &  fi,
    pasbool                  shared_file,
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17fadd_file_state (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  fileId,
    tbd_file_state_set    &  newState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17fsub_file_state (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  fileId,
    tbd_file_state_set    &  subState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17next_del_fdir (
    tgg00_Filename        &  prefix,
    integer                  prefix_len,
    tgg00_Filename        &  fn,
    tbd_fileinfo          &  fi,
    pasbool                  shared_file,
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17repl_fdir (
    tgg00_Filename        &  fn,
    tbd_fileinfo          &  fi,
    pasbool                  shared_file,
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17reset_read_only (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17restart_fdir (
    tgg00_TransContext    &  t,
    tsp00_PageNo             fdir_1_root,
    tsp00_PageNo             fdir_2_root);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17state_fdir (
    tgg00_Filename        &  fn,
    tbd_fileinfo          &  fi,
    pasbool                  shared_file,
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17succ_fdir (
    tgg00_Filename        &  fn,
    tgg00_Filename        &  next_fn,
    tbd_fileinfo          &  fi,
    pasbool                  shared_file,
    tgg00_TransContext    &  t,
    pasbool                  include_strcols);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b17unload_fdir (
    tgg00_Filename        &  fn,
    tbd_fileinfo          &  fi,
    pasbool                  shared_file,
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_PageNo bd17GetFdirRoot ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_PageNo bd17GetLongFdirRoot ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_PageNo bd17GetTempFdirRoot ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd17VerifyFdir (
    tgg00_TransContext    &  trans,
    pasbool                  bIsCold,
    pasbool                  bWithExtendedCheck);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd17VerifyLongFdir (
    tgg00_TransContext    &  trans,
    pasbool                  bIsCold,
    pasbool                  bWithExtendedCheck);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

