/*!
  @file           geo52.h
  @author         JoergM
  @special area   LZU Statistics
  @brief          description ...
  @see            example.html ...

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/



#ifndef GEO52_H
#define GEO52_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "geo00.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

#define MAX_DEVQUEUELEN_STAT_EO52 3

/* There is no task statistic reset pending */
#define EO52_NO_RESET_PENDING           0

/* This sort of reset is set, if 'x_cons RESET TASKS' was executed. */
/* It is handled in disaptcher entry code while console code sets the flag only */
#define EO52_RESET_TASK_FULL_PENDING    1

/* This sort of reset is set, if 'x_cons TIME ENABLE' was executed (while fTimeMeasure was false) */
/* It is handled in disaptcher entry code while console code sets the flag only */
#define EO52_RESET_TASK_PARTIAL_PENDING 2

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*
// +---------------------------------------------------------------+
// |   STATE STATISTIC                                             |
// +---------------------------------------------------------------+
*/

 typedef struct teo52_AbsoluteTimeRec
   {
   tsp00_Uint8                             ulAbsMicroSeconds;
   tsp00_Uint4                             ulCount;
   tsp00_Uint4                             padding;
   } teo52_AbsoluteTime ;


 typedef struct teo52_RelativeAndAbsoluteTimeRec
   {
   tsp00_Uint8                             ulAbsMicroSeconds;
   tsp00_Uint8                             ulRelMicroSeconds;
   tsp00_Uint4                             ulCount;
   tsp00_Uint4                             padding;
   } teo52_RelativeAndAbsoluteTime;

 typedef struct teo52_IOStatisticRec
   {
   teo52_AbsoluteTime                      IOStat;
   tsp00_Uint4                             ulPageCount;
   tsp00_Uint4                             padding;
   } teo52_IOStatisticRec ;


 typedef struct teo52_TaskDevIOStatisticRec
   {
   teo52_RelativeAndAbsoluteTime           IOStat;
   tsp00_Uint4                             ulPageCount;
   tsp00_Uint4                             padding;
   } teo52_TaskDevIOStatistic;

 /* PTS 1106969 */
 typedef struct teo52_TaskOMSStatisticRec
   {
   tsp00_KnlIdentifierc                    ProcedurName;
   tsp00_Uint4                             CallbackCount;
   tsp00_Int4                              MethodIdx;
   tsp00_Int4                              OMSCallActive;
   } teo52_TaskOMSStatisticRec ;
/*
// +---------------------------------------------------------------+
// |   TASK STATE STATISTIC                                        |
// +---------------------------------------------------------------+
*/

typedef struct teo52_TaskStateStatisticRec
  {
  teo52_IOStatisticRec            SelfIOReadStat, SelfIOWriteStat ;
  teo52_TaskDevIOStatistic        DevIOReadStat , DevIOWriteStat ;
  teo52_TaskDevIOStatistic        AsynIOReadStat, AsynIOWriteStat ;
  tsp00_Uint4                     ulDevQueueLen[MAX_DEVQUEUELEN_STAT_EO52] ;
  teo52_RelativeAndAbsoluteTime   VwaitStat ;
  teo52_RelativeAndAbsoluteTime   VsuspStat ;
  teo52_RelativeAndAbsoluteTime   VsleepStat ;
  teo52_RelativeAndAbsoluteTime   RplRcvStat ;
  teo52_AbsoluteTime              RcvRplStat ;
  SAPDB_UInt8                     vreceiveORvreplyLeaveTime; /* in microseconds */
  SAPDB_UInt8                     dispatcherEnterTime;       /* in microseconds */
  SAPDB_UInt8                     dispatcherLeaveTime;       /* in microseconds */
  SAPDB_UInt8                     runqueueEnqueueTime;       /* in microseconds */
#define EO52_TOO_LONG_LIMIT_IN_MICROSECONDS (1000000U)
  tsp00_Uint4                     ulRcvRplToLong ;   /* counter for commands that took longer that 1 second */
  tsp00_Uint4                     ulReschedMsecCount;
  } teo52_TaskStateStatisticRec;


typedef struct teo52_TaskQueueStatisticRec
  {
  tsp00_Uint4                              ulUKTQueCount;
  tsp00_Uint4                              ulUToUQueCount;
  tsp00_Uint4                              ulCOMQueCount;
  } teo52_TaskQueueStatistic;

/*
// +---------------------------------------------------------------+
// |   TASK PRIO STATISTIC                                         |
// +---------------------------------------------------------------+
*/
typedef struct teo52_TaskPrioStatisticRec
  {
  tsp00_Uint4                              ulTotalCount;
  tsp00_Uint4                              ulOtherUkt;
  } teo52_TaskPrioStatistic;

/*
// +---------------------------------------------------------------+
// |   DEV / ASDEV I/O STATISTIC                                         |
// +---------------------------------------------------------------+
*/
typedef struct teo52_DevIOStatisticRec
  {
  teo52_IOStatisticRec            DevRead;
  teo52_IOStatisticRec            DevWrite;
  tsp00_Uint4                     ulIOQueLen; /* This element will not be resetted!!! */
  tsp00_Uint4                     ulMaxIOQueLen;
  SAPDB_Bool                      ResetPending;
  } teo52_DevIOStatistic ;

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/


/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/


#endif  /* GEO52_H */
