/*!
  @file           heo52.h
  @author         JoergM
  @special area   time
  @brief          description ...
  @see            example.html ...

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/



#ifndef HEO52_H
#define HEO52_H


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/
#include "gsp00.h"
#include "heo00.h"
#include "geo52.h"

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

/*!
   @Description    Return seconds and microseconds since start of database
   @param          Sec [out] seconds since start
   @param          MicroSec [out] microseconds of last second (0-999999)

 */

externC void
vclock            ( teo00_Int4 * Sec,
                    teo00_Int4 * MicroSec);

/*!
   @Description    Return current time as timestamp


  Format of timestamp is  YYYYMMDDhhmmssuuuuuu
  Y Year digits
  M month digits
  D day digits
  h hour digits
  m minute digits
  s second digits
  u microsecond digits
   @param          pStamp [out] timestamp to fill

 */

externC void
vtimestamp        ( tsp00_Timestamp VAR_ARRAY_REF pStamp);

/*!
   @Description    Return current UTC time as timestamp


  Format of timestamp is  YYYYMMDDhhmmssuuuuuu
  Y Year digits
  M month digits
  D day digits
  h hour digits
  m minute digits
  s second digits
  u microsecond digits
   @param          pStamp [out] timestamp to fill

 */

externC void
vUTCtimestamp        ( tsp00_Timestamp VAR_ARRAY_REF pStamp);

/*!
   @Description    Return current date and time


  Format of date is YYYYMMDD. Format of time is hhmmss
  Y Year digits
  M month digits
  D day digits
  h hour digits
  m minute digits
  s second digits
   @param          pDate [out] date to fill
   @param          pTime [out] time to fill

 */

externC void
vdattime          ( tsp00_Date VAR_ARRAY_REF pDate,
                    tsp00_Time VAR_ARRAY_REF pTime );

/*
  Function: vTimeZoneDelta
  Description: Return difference between local time and GMT in hours

  Berlin winter time result 1.

  Berlin summer time result 2.

  New Zealand Chatham Islands result 12,75 !!!!

  NOTE: If weekday difference between localtime and systemtime is larger
  than a day, 0. is returned and a warning message is issued in knldiag.

  Return value: Difference in hours
 */
externC tsp00_Longreal vTimeZoneDelta();

/*!
   @Description    Update relative and absolute time record


  The difference (leaveDispatcher - enterDispatcher) is added to the AbsoluteTime record.
  The difference (enterRunqueue - enterDispatcher) is added to the RelativeTime record.
   @param          pRec [inout] record to update
   @param          pState [in] record containing dispatcher timestamps

 */

externC void eo52UpdateTaskStateStatisticRec(
 teo52_RelativeAndAbsoluteTime *pRec,
 teo52_TaskStateStatisticRec   *pState );

#endif  /* HEO52_H */
