/* @lastChanged: "1999-11-01"

  * @filename:   vgg91.cpp
  * @purpose:    "GG_kernel_classes"
  * @release:    7.2.0.0
  * @see:        ""
  *
  * @copyright:  (c) 1999-2004 SAP AG"


    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/

#include "ggg00.h"
#include "ggg91.h"
#include "hgg17.h"

/* ========================================================================== */
/* ==========                tgg91_FileVersion                      ========= */
/* ========================================================================== */

void tgg91_FileVersion::gg91AppendToLine (int        &LineLen,
                                          tsp00_Line &Line) const
{
    
    if ( this->gg91IsSpecialVers () )
    {
        gg90StrToLine (_T("special"), LineLen, Line);
        return;
    }
    
    if ( this->gg91IsDummyVers () )
    {
        gg90StrToLine (_T("dummy"), LineLen, Line);
        return;
    }
    
    this->gg90AppendToLine (LineLen, Line);
}



/* ========================================================================== */
/* ==========                 tgg91_SessionNo                       ========= */
/* ========================================================================== */

void tgg91_SessionNo::gg91AppendToLine (int        &LineLen,
                                        tsp00_Line &Line) const
{   
    if ( NIL_BYTE_GG90 == this->data_IV [0] )
    {
        
        // special SessionNo: FF ?? ?? ??
        
        if ( (0 == this->data_IV [1]) && (0 == this->data_IV [2]) )
        {
            // TASK SessionNo: FF 00 00 <TaskType>
            
            g17tasktype_to_line (this->data_IV [3], LineLen, Line.asCharp());
            return;
        }
        
        if ( (0 != this->data_IV [1]) && (NIL_BYTE_GG90 != this->data_IV [1]) )
        {
            // auxiliary SessionNo: FF <MessType> <counter hi> <counter lo>
            
			// PTS 1104414 JA 1999-11-01 MessType: second byte = data_IV [1]

            if  ( m_restore_parallel == this->data_IV [1] )
            {
                gg90StrToLine (_T("tape"), LineLen, Line);
                return;
            }
            
            if  ( m_save_parallel == this->data_IV [1] )
            {
                gg90StrToLine (_T("devspace"), LineLen, Line);
                return;
            }
            
            g17messtype_to_line ((tgg00_MessType_Enum) this->data_IV [1], LineLen, Line.asCharp());
            
            if ( (0 != this->data_IV [2]) || (0 != this->data_IV [3]) )
            {
                tgg90_Cint2 AuxCnt; 
                AuxCnt.becomes ( (char*) &(this->data_IV [2]) );
                AuxCnt.gg90AppendToLine (LineLen, Line);
            }
            return;
        }
    }
    
    this->gg90AppendToLine (LineLen, Line);
}
