/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.util.UnicodeUtil;
import com.sap.dbtech.vsp00.Vsp00Const;
import com.sap.dbtech.rte.comm.RteC;

/**
 *
 */
public class RequestPacketUnicode
    extends RequestPacket
{
    /**
     * creates a new RequestPacketUnicode
     */
    public
    RequestPacketUnicode (com.sap.dbtech.util.StructuredMem rawPacket, String applID, String applVers)
    {
        super (rawPacket, RteC.unicodeClient_C, applID, applVers);
    }
    /**
     *
     * @param data   String
     */
    public void addDataString (String data) {
        this.mem.putInt1 (Vsp00Const.definedUnicode_C, this.dataPos ());
        ++this.partLength;
        this.addString (data);
    }
    /**
     *
     * @param bytes byte[]
     */
    public void addString (String data) {
        char [] chars = data.toCharArray ();
        int lenInBytes = chars.length * UnicodeUtil.CharWidthC;
        this.mem.putBigUnicode(chars, this.dataPos (), lenInBytes);
        this.partLength += lenInBytes;
    }
    /**
     *
     * @param value java.lang.String
     * @param offset int
     */
    public int putString (
        String value,
        int offset)
    {
        return this.putString (value, offset, value.length ());
    }
    /**
     *
     * @return int
     * @param value java.lang.String
     * @param offset int
     * @param len int
     */
    public int putString (
        String value,
        int offset,
        int len)
    {
        char [] chars = value.toCharArray ();
        int lenInBytes = UnicodeUtil.CharWidthC;
        this.mem.putBigUnicode(chars, offset, len);
        return lenInBytes;
    }
}
