/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;


public class ClientDatabaseMetaDataSapDB
    implements DatabaseMetaData
{
    private DatabaseMetaData          originalMetaData;
    private ClientConnectionSapDB     clientConnection;
    
    public ClientDatabaseMetaDataSapDB(DatabaseMetaData originalMetaData,
                                       ClientConnectionSapDB clientConnection)
    {
        this.originalMetaData=originalMetaData;
        this.clientConnection=clientConnection;
    }

    public void exceptionOccurred(SQLException sqlEx) 
    {
        this.clientConnection.exceptionOccurred(sqlEx);
    }

    
    // Code for delegation of java.sql.DatabaseMetaData methods to originalMetaData

    public String getURL() throws SQLException
    {
        try {
            return originalMetaData.getURL();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isReadOnly() throws SQLException
    {
        try {
            return originalMetaData.isReadOnly();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getAttributes(String param1, String param2, String param3, String param4) throws SQLException
    {
        try {
            ResultSet tmp=originalMetaData.getAttributes(param1, param2, param3, param4);
            return tmp==null ? null : new ClientResultSetSapDB(tmp, this.clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    // return client connection instead to caller
    public Connection getConnection() throws SQLException
    {
        return this.clientConnection;
    }

    public int getResultSetHoldability() throws SQLException
    {
        try {
            return originalMetaData.getResultSetHoldability();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean allProceduresAreCallable() throws SQLException
    {
        try {
            return originalMetaData.allProceduresAreCallable();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean allTablesAreSelectable() throws SQLException
    {
        try {
            return originalMetaData.allTablesAreSelectable();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getUserName() throws SQLException
    {
        try {
            return originalMetaData.getUserName();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean nullsAreSortedHigh() throws SQLException
    {
        try {
            return originalMetaData.nullsAreSortedHigh();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean nullsAreSortedLow() throws SQLException
    {
        try {
            return originalMetaData.nullsAreSortedLow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean nullsAreSortedAtStart() throws SQLException
    {
        try {
            return originalMetaData.nullsAreSortedAtStart();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean nullsAreSortedAtEnd() throws SQLException
    {
        try {
            return originalMetaData.nullsAreSortedAtEnd();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getDatabaseProductName() throws SQLException
    {
        try {
            return originalMetaData.getDatabaseProductName();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getDatabaseProductVersion() throws SQLException
    {
        try {
            return originalMetaData.getDatabaseProductVersion();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getDriverName() throws SQLException
    {
        try {
            return originalMetaData.getDriverName();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getDriverVersion() throws SQLException
    {
        try {
            return originalMetaData.getDriverVersion();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getDriverMajorVersion()
    {
        return originalMetaData.getDriverMajorVersion();
    }

    public int getDriverMinorVersion()
    {
        return originalMetaData.getDriverMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException
    {
        try {
            return originalMetaData.usesLocalFiles();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean usesLocalFilePerTable() throws SQLException
    {
        try {
            return originalMetaData.usesLocalFilePerTable();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.supportsMixedCaseIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.storesUpperCaseIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.storesLowerCaseIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.storesMixedCaseIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.supportsMixedCaseQuotedIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.storesUpperCaseQuotedIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.storesLowerCaseQuotedIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException
    {
        try {
            return originalMetaData.storesMixedCaseQuotedIdentifiers();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getIdentifierQuoteString() throws SQLException
    {
        try {
            return originalMetaData.getIdentifierQuoteString();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getSQLKeywords() throws SQLException
    {
        try {
            return originalMetaData.getSQLKeywords();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getNumericFunctions() throws SQLException
    {
        try {
            return originalMetaData.getNumericFunctions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getStringFunctions() throws SQLException
    {
        try {
            return originalMetaData.getStringFunctions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getSystemFunctions() throws SQLException
    {
        try {
            return originalMetaData.getSystemFunctions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getTimeDateFunctions() throws SQLException
    {
        try {
            return originalMetaData.getTimeDateFunctions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getSearchStringEscape() throws SQLException
    {
        try {
            return originalMetaData.getSearchStringEscape();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getExtraNameCharacters() throws SQLException
    {
        try {
            return originalMetaData.getExtraNameCharacters();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException
    {
        try {
            return originalMetaData.supportsAlterTableWithAddColumn();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException
    {
        try {
            return originalMetaData.supportsAlterTableWithDropColumn();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsColumnAliasing() throws SQLException
    {
        try {
            return originalMetaData.supportsColumnAliasing();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean nullPlusNonNullIsNull() throws SQLException
    {
        try {
            return originalMetaData.nullPlusNonNullIsNull();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsConvert() throws SQLException
    {
        try {
            return originalMetaData.supportsConvert();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsConvert(int param1, int param2) throws SQLException
    {
        try {
            return originalMetaData.supportsConvert(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsTableCorrelationNames() throws SQLException
    {
        try {
            return originalMetaData.supportsTableCorrelationNames();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException
    {
        try {
            return originalMetaData.supportsDifferentTableCorrelationNames();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException
    {
        try {
            return originalMetaData.supportsExpressionsInOrderBy();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsOrderByUnrelated() throws SQLException
    {
        try {
            return originalMetaData.supportsOrderByUnrelated();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsGroupBy() throws SQLException
    {
        try {
            return originalMetaData.supportsGroupBy();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsGroupByUnrelated() throws SQLException
    {
        try {
            return originalMetaData.supportsGroupByUnrelated();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException
    {
        try {
            return originalMetaData.supportsGroupByBeyondSelect();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsLikeEscapeClause() throws SQLException
    {
        try {
            return originalMetaData.supportsLikeEscapeClause();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsMultipleResultSets() throws SQLException
    {
        try {
            return originalMetaData.supportsMultipleResultSets();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsMultipleTransactions() throws SQLException
    {
        try {
            return originalMetaData.supportsMultipleTransactions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsNonNullableColumns() throws SQLException
    {
        try {
            return originalMetaData.supportsNonNullableColumns();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException
    {
        try {
            return originalMetaData.supportsMinimumSQLGrammar();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsCoreSQLGrammar() throws SQLException
    {
        try {
            return originalMetaData.supportsCoreSQLGrammar();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException
    {
        try {
            return originalMetaData.supportsExtendedSQLGrammar();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException
    {
        try {
            return originalMetaData.supportsANSI92EntryLevelSQL();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException
    {
        try {
            return originalMetaData.supportsANSI92IntermediateSQL();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsANSI92FullSQL() throws SQLException
    {
        try {
            return originalMetaData.supportsANSI92FullSQL();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException
    {
        try {
            return originalMetaData.supportsIntegrityEnhancementFacility();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsOuterJoins() throws SQLException
    {
        try {
            return originalMetaData.supportsOuterJoins();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsFullOuterJoins() throws SQLException
    {
        try {
            return originalMetaData.supportsFullOuterJoins();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsLimitedOuterJoins() throws SQLException
    {
        try {
            return originalMetaData.supportsLimitedOuterJoins();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getSchemaTerm() throws SQLException
    {
        try {
            return originalMetaData.getSchemaTerm();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getProcedureTerm() throws SQLException
    {
        try {
            return originalMetaData.getProcedureTerm();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getCatalogTerm() throws SQLException
    {
        try {
            return originalMetaData.getCatalogTerm();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isCatalogAtStart() throws SQLException
    {
        try {
            return originalMetaData.isCatalogAtStart();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getCatalogSeparator() throws SQLException
    {
        try {
            return originalMetaData.getCatalogSeparator();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException
    {
        try {
            return originalMetaData.supportsSchemasInDataManipulation();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException
    {
        try {
            return originalMetaData.supportsSchemasInProcedureCalls();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException
    {
        try {
            return originalMetaData.supportsSchemasInTableDefinitions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException
    {
        try {
            return originalMetaData.supportsSchemasInIndexDefinitions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException
    {
        try {
            return originalMetaData.supportsSchemasInPrivilegeDefinitions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException
    {
        try {
            return originalMetaData.supportsCatalogsInDataManipulation();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException
    {
        try {
            return originalMetaData.supportsCatalogsInProcedureCalls();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException
    {
        try {
            return originalMetaData.supportsCatalogsInTableDefinitions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException
    {
        try {
            return originalMetaData.supportsCatalogsInIndexDefinitions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException
    {
        try {
            return originalMetaData.supportsCatalogsInPrivilegeDefinitions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsPositionedDelete() throws SQLException
    {
        try {
            return originalMetaData.supportsPositionedDelete();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsPositionedUpdate() throws SQLException
    {
        try {
            return originalMetaData.supportsPositionedUpdate();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSelectForUpdate() throws SQLException
    {
        try {
            return originalMetaData.supportsSelectForUpdate();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsStoredProcedures() throws SQLException
    {
        try {
            return originalMetaData.supportsStoredProcedures();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException
    {
        try {
            return originalMetaData.supportsSubqueriesInComparisons();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSubqueriesInExists() throws SQLException
    {
        try {
            return originalMetaData.supportsSubqueriesInExists();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSubqueriesInIns() throws SQLException
    {
        try {
            return originalMetaData.supportsSubqueriesInIns();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException
    {
        try {
            return originalMetaData.supportsSubqueriesInQuantifieds();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException
    {
        try {
            return originalMetaData.supportsCorrelatedSubqueries();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsUnion() throws SQLException
    {
        try {
            return originalMetaData.supportsUnion();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsUnionAll() throws SQLException
    {
        try {
            return originalMetaData.supportsUnionAll();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException
    {
        try {
            return originalMetaData.supportsOpenCursorsAcrossCommit();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException
    {
        try {
            return originalMetaData.supportsOpenCursorsAcrossRollback();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException
    {
        try {
            return originalMetaData.supportsOpenStatementsAcrossCommit();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException
    {
        try {
            return originalMetaData.supportsOpenStatementsAcrossRollback();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxBinaryLiteralLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxBinaryLiteralLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxCharLiteralLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxCharLiteralLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxColumnNameLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxColumnNameLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxColumnsInGroupBy() throws SQLException
    {
        try {
            return originalMetaData.getMaxColumnsInGroupBy();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxColumnsInIndex() throws SQLException
    {
        try {
            return originalMetaData.getMaxColumnsInIndex();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxColumnsInOrderBy() throws SQLException
    {
        try {
            return originalMetaData.getMaxColumnsInOrderBy();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxColumnsInSelect() throws SQLException
    {
        try {
            return originalMetaData.getMaxColumnsInSelect();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxColumnsInTable() throws SQLException
    {
        try {
            return originalMetaData.getMaxColumnsInTable();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxConnections() throws SQLException
    {
        try {
            return originalMetaData.getMaxConnections();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxCursorNameLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxCursorNameLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxIndexLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxIndexLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxSchemaNameLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxSchemaNameLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxProcedureNameLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxProcedureNameLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxCatalogNameLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxCatalogNameLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxRowSize() throws SQLException
    {
        try {
            return originalMetaData.getMaxRowSize();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException
    {
        try {
            return originalMetaData.doesMaxRowSizeIncludeBlobs();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxStatementLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxStatementLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxStatements() throws SQLException
    {
        try {
            return originalMetaData.getMaxStatements();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxTableNameLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxTableNameLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxTablesInSelect() throws SQLException
    {
        try {
            return originalMetaData.getMaxTablesInSelect();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxUserNameLength() throws SQLException
    {
        try {
            return originalMetaData.getMaxUserNameLength();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getDefaultTransactionIsolation() throws SQLException
    {
        try {
            return originalMetaData.getDefaultTransactionIsolation();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsTransactions() throws SQLException
    {
        try {
            return originalMetaData.supportsTransactions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsTransactionIsolationLevel(int param1) throws SQLException
    {
        try {
            return originalMetaData.supportsTransactionIsolationLevel(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException
    {
        try {
            return originalMetaData.supportsDataDefinitionAndDataManipulationTransactions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException
    {
        try {
            return originalMetaData.supportsDataManipulationTransactionsOnly();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException
    {
        try {
            return originalMetaData.dataDefinitionCausesTransactionCommit();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException
    {
        try {
            return originalMetaData.dataDefinitionIgnoredInTransactions();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getProcedures(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs=originalMetaData.getProcedures(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getProcedureColumns(String param1, String param2, String param3, String param4) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getProcedureColumns(param1, param2, param3, param4);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getTables(String param1, String param2, String param3, String[] param4) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getTables(param1, param2, param3, param4);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getSchemas() throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getSchemas();
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getCatalogs() throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getCatalogs();
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getTableTypes() throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getTableTypes();
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getColumns(String param1, String param2, String param3, String param4) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getColumns(param1, param2, param3, param4);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getColumnPrivileges(String param1, String param2, String param3, String param4) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getColumnPrivileges(param1, param2, param3, param4);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getTablePrivileges(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getTablePrivileges(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getBestRowIdentifier(String param1, String param2, String param3, int param4, boolean param5) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getBestRowIdentifier(param1, param2, param3, param4, param5);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getVersionColumns(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getVersionColumns(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getPrimaryKeys(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getPrimaryKeys(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getImportedKeys(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getImportedKeys(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getExportedKeys(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getExportedKeys(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getCrossReference(String param1, String param2, String param3, 
                                       String param4, String param5, String param6) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getCrossReference(param1, param2, param3, param4, param5, param6);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getTypeInfo() throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getTypeInfo();
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getIndexInfo(String param1, String param2, String param3, boolean param4, boolean param5) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getIndexInfo(param1, param2, param3, param4, param5);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsResultSetType(int param1) throws SQLException
    {
        try {
            return originalMetaData.supportsResultSetType(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsResultSetConcurrency(int param1, int param2) throws SQLException
    {
        try {
            return originalMetaData.supportsResultSetConcurrency(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean ownUpdatesAreVisible(int param1) throws SQLException
    {
        try {
            return originalMetaData.ownUpdatesAreVisible(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean ownDeletesAreVisible(int param1) throws SQLException
    {
        try {
            return originalMetaData.ownDeletesAreVisible(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean ownInsertsAreVisible(int param1) throws SQLException
    {
        try {
            return originalMetaData.ownInsertsAreVisible(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean othersUpdatesAreVisible(int param1) throws SQLException
    {
        try {
            return originalMetaData.othersUpdatesAreVisible(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean othersDeletesAreVisible(int param1) throws SQLException
    {
        try {
            return originalMetaData.othersDeletesAreVisible(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean othersInsertsAreVisible(int param1) throws SQLException
    {
        try {
            return originalMetaData.othersInsertsAreVisible(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean updatesAreDetected(int param1) throws SQLException
    {
        try {
            return originalMetaData.updatesAreDetected(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean deletesAreDetected(int param1) throws SQLException
    {
        try {
            return originalMetaData.deletesAreDetected(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean insertsAreDetected(int param1) throws SQLException
    {
        try {
            return originalMetaData.insertsAreDetected(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsBatchUpdates() throws SQLException
    {
        try {
            return originalMetaData.supportsBatchUpdates();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getUDTs(String param1, String param2, String param3, int[] param4) throws SQLException
    {
        try {
            return originalMetaData.getUDTs(param1, param2, param3, param4);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsSavepoints() throws SQLException
    {
        try {
            return originalMetaData.supportsSavepoints();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsNamedParameters() throws SQLException
    {
        try {
            return originalMetaData.supportsNamedParameters();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsMultipleOpenResults() throws SQLException
    {
        try {
            return originalMetaData.supportsMultipleOpenResults();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsGetGeneratedKeys() throws SQLException
    {
        try {
            return originalMetaData.supportsGetGeneratedKeys();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getSuperTypes(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getSuperTypes(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getSuperTables(String param1, String param2, String param3) throws SQLException
    {
        try {
            ResultSet rs = originalMetaData.getSuperTables(param1, param2, param3);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, null);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsResultSetHoldability(int param1) throws SQLException
    {
        try {
            return originalMetaData.supportsResultSetHoldability(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getDatabaseMajorVersion() throws SQLException
    {
        try {
            return originalMetaData.getDatabaseMajorVersion();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getDatabaseMinorVersion() throws SQLException
    {
        try {
            return originalMetaData.getDatabaseMinorVersion();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getJDBCMajorVersion() throws SQLException
    {
        try {
            return originalMetaData.getJDBCMajorVersion();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getJDBCMinorVersion() throws SQLException
    {
        try {
            return originalMetaData.getJDBCMinorVersion();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getSQLStateType() throws SQLException
    {
        try {
            return originalMetaData.getSQLStateType();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean locatorsUpdateCopy() throws SQLException
    {
        try {
            return originalMetaData.locatorsUpdateCopy();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean supportsStatementPooling() throws SQLException
    {
        try {
            return originalMetaData.supportsStatementPooling();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

}
