/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.rte.comm;

import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

/**
 * various constants as specified in C-headerfiles.
 */
public class RteC {
    // request/reply types
    public final static int RSQL_RTE_PROT_TCP_C          =      3;
    public final static int RSQL_INFO_REQUEST_C          =     51;
    public final static int RSQL_INFO_REPLY_C            =     52;
    public final static int RSQL_USER_CONN_REQUEST_C     =     61;
    public final static int RSQL_USER_CONN_REPLY_C       =     62;
    public final static int RSQL_USER_DATA_REQUEST_C     =     63;
    public final static int RSQL_USER_DATA_REPLY_C       =     64;
    public final static int RSQL_USER_CANCEL_REQUEST_C   =     65;
    public final static int RSQL_USER_RELEASE_REQUEST_C  =     66;
    public final static int RSQL_KERN_CONN_REQUEST_C     =     71;
    public final static int RSQL_KERN_CONN_REPLY_C       =     72;
    public final static int RSQL_KERN_DATA_REQUEST_C     =     73;
    public final static int RSQL_KERN_DATA_REPLY_C       =     74;
    public final static int RSQL_KERN_RELEASE_REQUEST_C  =     76;
    public final static int RSQL_DUMP_REQUEST_C          =     81;
    public final static int RSQL_CTRL_CONN_REQUEST_C     =     91;
    public final static int RSQL_CTRL_CONN_REPLY_C       =     92;
    public final static int RSQL_CTRL_CANCEL_REQUEST_C   =     93;
    public final static int RSQL_NORMAL_C                =      0;
    // rte return codes
    public final static int SQLOK_C                      =      0;
    public final static int SQLNOTOK_C                   =      1;
    public final static int SQLTASKLIMIT_C               =      2;
    public final static int SQLTIMEOUT_C                 =      3;
    public final static int SQLCRASH_C                   =      4;
    public final static int SQLSTART_REQUIRED_C          =      5;
    public final static int SQLSHUTDOWN_C                =      6;
    public final static int SQLSEND_LINE_DOWN_C          =      7;
    public final static int SQLRECEIVE_LINE_DOWN_C       =      8;
    public final static int SQLPACKETLIMIT_C             =      9;
    public final static int SQLRELEASED_C                =     10;
    public final static int SQLWOULDBLOCK_C              =     11;
    public final static int SQLUNKNOWN_REQUEST_C         =     12;
    public final static int SQLSERVER_OR_DB_UNKNOWN_C    =     13;

    public static final String [] CommunicationErrors_C = {
        "OK",
        "Connection down, session released",
        "Tasklimit",
        "Timeout",
        "Crash",
        "Restart required",
        "Shutdown",
        "Send line down",
        "Receive line down",
        "Packet limit",
        "Released",
        "Would block",
        "Unknown Request",
        "Server or DB unknown",
    };

    public static final String communicationErrorKeys[] = {
        MessageKey.COMMERROR_OK,
        MessageKey.COMMERROR_CONNECTDOWN,
        MessageKey.COMMERROR_TASKLIMIT,
        MessageKey.COMMERROR_TIMEOUT,
        MessageKey.COMMERROR_CRASH,
        MessageKey.COMMERROR_RESTARTREQUIRED,
        MessageKey.COMMERROR_SHUTDOWN,
        MessageKey.COMMERROR_SENDLINEDOWN,
        MessageKey.COMMERROR_RECVLINEDOWN,
        MessageKey.COMMERROR_PACKETLIMIT,
        MessageKey.COMMERROR_RELEASED,
        MessageKey.COMMERROR_WOULDBLOCK,
        MessageKey.COMMERROR_UNKNOWNREQUEST,
        MessageKey.COMMERROR_SERVERDBUNKNOWN
    };
    /*error code mapping equivalent to precompiler/odbc
      also defined in gsp01.h and vni75.c*/
    public static final int [] CommunicationErrorCodeMap_C = {
        -708,
        -807,
        -9807,
        700,
        800,
        -813,
        -708,
        -708,
        -708,
        -708,
        -807,
        -708,
        -708,
        -709,
    };

    // user types
    public final static int SQL_USER_C                   =      0;
    public final static int SQL_ASYNC_USER_C             =      1;
    public final static int SQL_UTILITY_C                =      2;
    public final static int SQL_DISTRIBUTION_C           =      3;
    public final static int SQL_CONTROL_C                =      4;
    public final static int SQL_EVENT_C                  =      5;
    // Type RTE_HEADER_REC -> Header
    public final static int Header_ActSendLen_O          =      0;   // INT4
    public final static int Header_ProtocolID_O          =      4;   // INT1
    public final static int Header_MessClass_O           =      5;   // INT1
    public final static int Header_RTEFlags_O            =      6;   // INT1
    public final static int Header_ResidualPackets_O     =      7;   // INT1
    public final static int Header_SenderRef_O           =      8;   // INT4
    public final static int Header_ReceiverRef_O         =     12;   // INT4
    public final static int Header_RTEReturnCode_O       =     16;   // INT2
    public final static int Header_Filler_O              =     18;   // INT2
    public final static int Header_MaxSendLen_O          =     20;   // INT4
    public final static int Header_END_O_C               =     24;
    // Type RTE_CONNECT_PACKET_REC -> Connect
    public final static int Connect_sMessCode_O          =      0;   // C2
    public final static int Connect_ConnectLength_O      =      2;   // INT2
    public final static int Connect_ServiceType_O        =      4;   // INT1
    public final static int Connect_OSType_O             =      5;   // INT1
    public final static int Connect_Filler1_O            =      6;   // INT1
    public final static int Connect_Filler2_O            =      7;   // INT1
    public final static int Connect_MaxSegmentSize_O     =      8;   // INT4
    public final static int Connect_MaxDataLen_O         =     12;   // INT4
    public final static int Connect_PacketSize_O         =     16;   // INT4
    public final static int Connect_MinReplySize_O       =     20;   // INT4
    public final static int Connect_ReceiverServerDB_O   =     24;   // C8
    public final static int Connect_SenderServerDB_O     =     32;   // C8
    public final static int Connect_VarPart_O            =     40;   // C256
    public final static int Connect_END_O_C              =    296;
    // other connect header constants
    public final static int Connect_Dbname_Size_C        =      8;
    public static final int Connect_MinSize_C            =     64;   // for Unix vserver
    public final static int ARGID_PORT_NO_C              =   0x50;   // = P
    public final static int ARGID_REM_PID_C              =   0x49;   // = I
    public final static int ARGID_ACKNOWLEDGE_C          =   0x52;   // = R
    public final static int ARGID_NODE_C                 =   0x3E;   // = N
    public final static int ARGID_DBROOT_C               =   0x64;   // = d
    public final static int ARGID_SERVERPGM_C            =   0x70;   // = p
    // some constants
    public final static int asciiClient_C                =      0;
    public final static int ebcdicClient_C               =      1;
    public static final int unicodeSwapClient_C          =     19;
    public static final int unicodeClient_C              =     20;
    public static final int unicodeNativeClient_C        =     21;
    public static final int utf8Client_C                 =     22;
    public final static int notSwapped_C                 =      1;
    public final static int fullSwapped_C                =      2;
    public final static int halfSwapped_C                =      3;
    public final static int RSQL_WIN32_C                 =     13;
    public final static int RSQL_JAVA_C                  = RSQL_WIN32_C;
    public final static int defaultPort_C                =   7210;
    public final static int defaultSecurePort_C          =   7270;

    /**
     *
     */
    static String
    getCommunicationError (int rteRC)
    {
        String result;

        //if ((0 <= rteRC) && (rteRC < CommunicationErrors_C.length)) {
            // result = CommunicationErrors_C [rteRC];
        if ((0 <= rteRC) && (rteRC < communicationErrorKeys.length)) {
            result=MessageTranslator.translate(communicationErrorKeys[rteRC]);
        }
        else {
            result = MessageTranslator.translate(MessageKey.COMMERROR, Integer.toString(rteRC));
        }
        return result;
    }
        /**
     *
     */
    static int
    getCommunicationErrorMapCode (int rteRC)
    {
        int result = -708;

        if ((0 <= rteRC) && (rteRC < CommunicationErrorCodeMap_C.length)) {
            result = CommunicationErrorCodeMap_C [rteRC];
        }
        else {
            result = -708;
        }
        return result;
    }
}
