/*-
 * Copyright (c) 1998, 2002-2005 Kiyoshi Matsui <kmatsui@t3.rim.or.jp>
 * All rights reserved.
 *
 * Some parts of this code are derived from the public domain software
 * DECUS cpp (1984,1985) written by Martin Minow.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 *                          S Y S T E M . H
 *                  S y s t e m   D e p e n d e n t
 *              D e f i n i t i o n s   f o r   M C P P
 *
 * Definitions in this file may be edited to configure MCPP for particular
 * operating systems and compiler configurations.
 *
 * Note:  MCPP assumes the system implement the Ascii character set.
 * If this is not the case, you will have to do some editing here and there.
 *
 * 1984/05 - 1985/06    CPP / cppdef.h
 *              Created and released on USENET.             by Martin Minow
 *
 * 1998/08      CPP Version 2.0 / system.H
 *              Re-written and renamed from cppdef.h.           by kmatsui
 * 1998/09      CPP Version 2.1 / system.H
 *              Updated according to C99-1998/08 draft.         by kmatsui
 * 1998/11      CPP Version 2.2 / system.H
 *              Updated according to C++ Standard (ISO/IEC 14882).
 *                                                              by kmatsui
 * 2002/08      CPP Version 2.3 pre-release 1 / system.H
 *              Updated according to C99 (ISO/IEC 9899:1999).   by kmatsui
 * 2002/12      CPP Version 2.3 pre-release 2 / system.H
 *              Slightly modified.                              by kmatsui
 * 2003/02      CPP Version 2.3 release / system.H
 *              Changed macros of include directory.            by kmatsui
 * 2003/11      MCPP Version 2.4 pre-release / system.H
 *              Uses 'configure'd config.h when available.
 *              Added implementation for Visual C.
 *              Removed CON_NOEXPAND and CON_EXPAND modes, renamed CON_FALSE
 *                  mode as PRE_STANDARD.
 *              Removed settings on VMS, DEC C and OS-9/09.     by kmatsui
 * 2004/02      MCPP Version 2.4 release / system.H
 *              Extended multi-byte character handling.         by kmatsui
 * 2005/03      MCPP Version 2.5 / system.H
 *              Absorbed POST_STANDARD mode into STANDARD mode and made
 *                  available through -@post option.
 *              Made OLD_PREPROCESSOR configuration available through -@old
 *                  option in PRE_STANDARD mode.                by kmatsui
 */

#define SYSTEM_H

#define TRUE                1
#define FALSE               0

#if     HAVE_CONFIG_H
#include    "configed.H"
#else
#include    "noconfig.H"
#endif

/*
 *      PART 1 and PART 2 are defined in the above header files.
 */

/*
 *      P A R T   1     Configurations for target-operating-system
 *                      and target-compiler.
 */

/*
 *      P A R T   2     Configurations for host-compiler.
 */

/*
 *      P A R T   3     Configurations for mode of macro expansion, mode of
 *                      tokenization, available preprocessing directives and
 *                      translation limits.
 */

/*
 * MODE     specifies the mode of preprocessing as one of STANDARD or
 *      PRE_STANDARD.  Those two modes have many differences each other --
 *      i.e. handling of translation phases; handling of some preprocessing
 *      tokens; availability of some directives; mode of macro expansion;
 *      -- as follows.
 *
 * PRE_STANDARD     Actual arguments of a macro are expanded (after
 *      substitution) with rest of the replacement text and the subsequent
 *      source text.
 *          Intermediately recursive macro call causes an error.
 *          <backslash><newline> sequence is deleted only in string literals
 *      and in #define directive lines.
 *          ## has no significance to cpp.  The tokens are macro-expanded
 *      separately.
 *          # has no significance to cpp.  The following token is expanded.
 *          Directly or intermediately recursive macro call causes an error.
 *          PRE_STANDARD corresponds to the "K&R 1st." and "Reiser model"
 *      preprocessing (the latter can be specified by -@old option).
 *
 * STANDARD     <backslash><newline> sequence is always deleted after trigraph
 *      conversion and before tokenization.
 *          Digraph sequences are recognized as tokens.
 *          Actual arguments of a macro are expanded separately prior to
 *      re-scanning of the replacement text.
 *          The name in the replacement text once expanded is not re-expanded,
 *      thus preventing recursive death.
 *          ## concatenates tokens.  The tokens are not expanded.  The con-
 *      catenated token is expanded by rescanning.
 *          # stringizes the following argument.  The argument is not
 *      expanded.  \ is inserted before " and \ in or surrounding the string
 *      literal or character constant (except in MBCHAR literals).  White-
 *      spaces between the tokens are squeezed to a space, \n is converted to
 *      a space.
 *          An expanded macro is surrounded by spaces to prevent unintended
 *      token merging.
 *
 *          -@post option specifies "post-Standard" behavior in STANDARD mode.    
 *      "post-Standard" mode simplifies the behavior of STD mode as follows.
 *          1. Digraph sequences are converted in translation phase 1, as
 *      alternate characters rather than as tokens.
 *          2. A space is inserted as a token separator between any tokens in
 *      a source (except a macro name and the next '(' in macro definition) :
 *      thus simplifying tokenization, test of macro redefinition and macro
 *      expansion especially "stringization".
 *          3. Test of macro redefinition ignores difference of parameter
 *      names, test of which has little utility and not a little overhead.
 *          4. #if expression forbids character constants, which have little
 *      portability, little utility and not a little overhead.
 *          5. Rescanning of a macro expansion is limited in the replacement
 *      text, rest of the source file is not scanned, thus making the syntax
 *      of "function-like" macro call more similar to that of function call.
 *          6. Argument of #include directive in <header.h> form is an obso-
 *      lescent feature.
 *          7. '$' or so are not treated specially in #define directive.
 *          8. Trigraphs, UCN (universal-character name) are not recognized.
 *          9. Multi-byte characters in an identifier are not recognized.
 *          10. #if sizeof (type) is disallowed as the Standards says
 *      (although STD mode with OK_SIZE configuration permits this).
 *
 * The following specifications are available when MODE == STANDARD.
 *      preprocessing number token, digraphs,
 *      #pragma (#pragma MCPP put_defines, #pragma MCPP once
 *          , #pragma MCPP include_next, #pragma MCPP warning
 *          , #pragma MCPP debug) directive,
 *      #error directive,
 *      #if defined operator, #elif directive,
 *      predefined macros __FILE__, __LINE__, __DATE__, __TIME__
 *          , __STDC__, __STDC_VERSION__, __STDC_HOSTED__,
 *      wide character constant, wide character string literal,
 *      _Pragma() operator, variable-arguments macro,
 *      macro as an argument of #include, #line directives,
 *      escape sequences \x[hex-digits], \a, \v,
 *      concatenation of string literals,
 *      '+' option (C++ preprocessing),
 *      'S<n>' option (re-defines __STDC__ as <n>, unpredefine some macros),
 *      'V<n>' option (re-defines __STDC_VERSION__ or __cplusplus as <n>),
 *      'h<n>' option (re-defines __STDC_HOSTED__ as <n>).
 * The following specifications are available only in STANDARD and not "post-
 *          Standard" mode.
 *      Trigraphs and UCN,
 *      Multi-byte characters in an identifier.
 * The following specifications are available only in PRE_STANDARD mode.
 *      #assert, #asm, #endasm, #put_defines, #include_next, #warning, #debug
 *          and some other older directives,
 *      argument of #line directive other than dicimal-digits or out of range
 *          of [1,32767].
 */
#define PRE_STANDARD        0
#define STANDARD            1

/* MODE         Specify the preprocessing mode. */
#ifndef MODE
#define MODE                STANDARD
#endif

/* POST_STD, OLD_PREP are the values of 'mode'. */
#define STD                 0   /* Default of STANDARD          */
#define POST_STD            2   /* Special mode of STANDARD     */
#define KR                  0   /* Default of PRE_STANDARD      */
#define OLD_PREP            1   /* Special mode of PRE_STANDARD */

#if     MODE == STANDARD && ! CAN_CONCAT_STRINGS
#define CONCAT_STRINGS      TRUE
#else
#define CONCAT_STRINGS      FALSE
#endif

/*
 * OK_SIZE permits sizeof operator in #if expression.
 * See definitions of S_CHAR, etc. in eval.c.
 * This is disallowed by the Standard.
 */
#if     MODE == STANDARD
#define OK_SIZE             FALSE
#else
#define OK_SIZE             TRUE
#endif

/*
 * TFLAG_INIT   Initial value for the -3 option.  If TRUE -3
 *              disables trigraphs, if FALSE -3 enables them.
 */
#if     MODE == STANDARD
#define OK_TRIGRAPHS        TRUE
#if     OK_TRIGRAPHS
#define TFLAG_INIT          FALSE
#endif
#endif

/*
 * DIGRAPHS_INIT    Initial value for the -2 option.  If TRUE -2
 *              disables digraphs, if FALSE -2 enables them.
 * OK_PRAGMA_OP     Enable _Pragma() operator by -V199901L option.
 * OK_UCN       Enable recognition of Universal-Character-Name sequence
 *              by -V199901L option.
 * OK_MBIDENT   Enable multi-byte characters in identifier by -V199901L
 *              option.
 * EXPAND_PRAGMA    Enable macro expansion of #pragma line by -V199901L.
 * expr_t, uexpr_t      Type of maximum integer. long (unsigned long) for C90
 *              and long long (unsigned long long) or longer for C99.
 * EXPR_MAX should be defined to the maximum value of uexpr_t,
 *              or maximum value of expr_t in case of !HAVE_UNSIGNED_LONG.
 */
#if     MODE == STANDARD
#define OK_DIGRAPHS         TRUE
#if     OK_DIGRAPHS
#define DIGRAPHS_INIT       FALSE
#endif
#define OK_PRAGMA_OP        TRUE
#ifndef EXPAND_PRAGMA
#define EXPAND_PRAGMA       FALSE
#endif
#define OK_UCN              TRUE
#define OK_MBIDENT          FALSE
#endif

#if     MODE == STANDARD
#if     HAVE_INTMAX_T
#if     HAVE_STDINT_H
#include    "stdint.h"
#else
#if     HAVE_INTTYPES_H
#include    "inttypes.h"
#endif
#endif
typedef intmax_t    expr_t;
typedef uintmax_t   uexpr_t;
#else
#if     HAVE_LONG_LONG || HAVE___INT64
#if     HAVE___INT64 || COMPILER == MSC || COMPILER == BORLANDC
typedef __int64     expr_t;
typedef unsigned __int64    uexpr_t;
#else
typedef long long   expr_t;
typedef unsigned long long  uexpr_t;
#endif
#else   /* !HAVE_LONG_LONG  */
#if     HAVE_UNSIGNED_LONG
typedef unsigned long   uexpr_t;
#else
typedef long    uexpr_t;
#endif  /* HAVE_UNSIGNED_LONG   */
typedef long    expr_t;
#endif  /* HAVE_LONG_LONG   */
#endif  /* HAVE_INTMAX_T    */
#endif  /* MODE == STANDARD */

#if     MODE == PRE_STANDARD
typedef long    expr_t;
#if     HAVE_UNSIGNED_LONG
typedef unsigned long   uexpr_t;
#else
typedef long    uexpr_t;
#endif
#endif

#if     MODE == STANDARD
#if     HAVE_INTMAX
#define EXPR_MAX            UINTMAX_MAX
#else
#if     HAVE_LONG_LONG
#define EXPR_MAX            0xFFFFFFFFFFFFFFFFULL
#else
#if     HAVE_UNSIGNED_LONG
#define EXPR_MAX            4294967295UL
#else
#define EXPR_MAX            2147483647L
#endif
#endif
#endif
#endif  /* MODE == STANDARD */

#if     MODE == PRE_STANDARD
#if     HAVE_UNSIGNED_LONG
#define EXPR_MAX            4294967295UL
#else
#define EXPR_MAX            2147483647L
#endif
#endif

/*
 * DOLLAR_IN_NAME   Should be set TRUE if $ is a valid letter in identifiers
 *              or FALSE if $ is invalid.
 */
#ifndef DOLLAR_IN_NAME
#define DOLLAR_IN_NAME      FALSE
#endif

/*
 * OK_MAKE      implement -M* options to put source file dependency line
 *              for 'make'.
 */
#define OK_MAKE             TRUE

/*
 * For #pragma MCPP debug, #debug.
 */
#define DEBUG               TRUE    /* for debugging of cpp */
#define DEBUG_EVAL          TRUE    /* for debug of cpp #if expression      */

/*
 * Translation limits.
 * The following definitions are used to allocate memory for work buffers.
 *
 * NWORK        Output buffer size.  Set this size according to your compiler-
 *              proper.  Length of string literal should be less than NWORK
 *              - 1.
 * NBUFF        Input buffer size after line concatenation by <backslash>
 *              <newline>.
 * NMACWORK     Internal work buffer size for macro definition and expansion.
 * IDMAX        The longest identifier length.
 * NMACPARS     The maximum number of #define parameters.
 *              NOTE: Must be NMACPARS <= UCHARMAX.
 * NEXP         The maximum nesting depth of #if expressions.
 * BLK_NEST     The number of nested #if's permitted.
 * NINCLUDE     The number of directories that may be specified on a per-
 *              system basis, or by the -I option.
 * RESCAN_LIMIT The maximum rescan times of macro expansion.
 *
 * NBUFF should not be smaller than NWORK.
 * NMACWORK should not be smaller than NWORK * 2.
 *
 * SBSIZE defines the number of hash-table slots for the macro symbol table.
 * It must be a power of 2.
 *
 * MKDEP_MAX    The maximum number of filenames in a dependency line of
 *              output of -M* option.
 */

#if     SYSTEM == SYS_MSDOS
#if     SYSTEM == SYS_MSDOS
#define NINCLUDE            0x10
#if     __TINY__ || __SMALL__ || __MEDIUM__ || M_I86TM || M_I86SM || M_I86MM
#define IDMAX               0x3F
#define NMACPARS            0x7F
#define NEXP                0x40
#define BLK_NEST            0x40
#define RESCAN_LIMIT        0x20
#define NBUFF               0x400
#define SBSIZE              0x100
#define MKDEP_MAX           0x20
#else
#define IDMAX               0xFF
#define NBUFF               0x1000
#define SBSIZE              0x200
#define MKDEP_MAX           0x40
#endif
#endif

#else
#if     SYSTEM == SYS_DJGPP
#define NBUFF               0x4000
#endif
#endif

/* For the systems of 32 bits or more.  */
#ifndef IDMAX
#define IDMAX               0x400
#endif
#ifndef NMACPARS
#define NMACPARS            0xFF
#endif
#ifndef NEXP
#define NEXP                0x100
#endif
#ifndef BLK_NEST
#define BLK_NEST            0x100
#endif
#ifndef NINCLUDE
#define NINCLUDE            0x40
#endif
#ifndef RESCAN_LIMIT
#define RESCAN_LIMIT        0x40
#endif
#ifndef NBUFF
#define NBUFF               0x10000     /* Must be NWORK <= NBUFF   */
#endif
#ifndef NWORK
#define NWORK               NBUFF       /* 0x400, 0x1000, 0x4000, ..    */
#endif
#ifndef NMACWORK
#define NMACWORK            (NWORK * 4) /* Must be NWORK * 2 <= NMACWORK    */
#endif
#ifndef SBSIZE
#define SBSIZE              0x400
#endif
#ifndef MKDEP_MAX
#define MKDEP_MAX           0x100
#endif

#if     UCHARMAX < NMACPARS
    error  <<NMACPARS should not be greater than UCHARMAX>>
#endif

#if     NBUFF < NWORK
    error   <<NBUFF must be same or greater than NWORK>>
#endif
#if     NMACWORK < NWORK * 2
    error   <<NMACWORK must be same or greater than NWORK * 2>>
#endif

#define SBMASK  (SBSIZE - 1)
#if     (SBSIZE ^ SBMASK) != ((SBSIZE * 2) - 1)
    error  <<SBSIZE must be a power of 2 !>>
#endif

#if     MODE == STANDARD
/*
 * Translation limits required by the Standard.
 *
 * *90MIN   limits specified by C90.
 * *99MIN   limits specified by C99.
 * *_CPLUS_MIN  limits recommended by C++ (ISO 1998/07 Standard).
 *
 * SLEN*MIN     Characters in a logical source line
 *              and characters in a string literal or wide string literal
 *              (after concatenation).
 * IDLEN*MIN    Significant initial characters in an internal identifier
 *              or a macro name.
 * NMACPARS*MIN     Parameters in one macro definition.
 *              Arguments in one macro invocation.
 * EXP_NEST*MIN     Nesting levels of parenthesized expressions in a full
 *              expression.
 * BLK_NEST*MIN     Nesting levels of conditional inclusion.
 * INCLUDE_NEST*MIN     Nesting levels for #include files.
 * NMACRO*MIN   Macro identifiers simultaneously defined in one translation
 *              unit.
 */
#define SLEN90MIN           0x1FD
#define IDLEN90MIN          0x1F
#define NMACPARS90MIN       0x1F
#define EXP_NEST90MIN       0x20
#define BLK_NEST90MIN       8
#define INCLUDE_NEST90MIN   8
#define NMACRO90MIN         0x400

#define SLEN99MIN           0xFFF
#define IDLEN99MIN          0x3F
#define NMACPARS99MIN       0x7F
#define EXP_NEST99MIN       0x3F
#define BLK_NEST99MIN       0x3F
#define INCLUDE_NEST99MIN   0xF
#define NMACRO99MIN         0xFFF

#define SLEN_CPLUS_MIN      0x10000
#define IDLEN_CPLUS_MIN     0x400
#define NMACPARS_CPLUS_MIN  0x100
#define EXP_NEST_CPLUS_MIN  0x100
#define BLK_NEST_CPLUS_MIN  0x100
#define INCLUDE_NEST_CPLUS_MIN  0x100
#define NMACRO_CPLUS_MIN    0x10000

/* LINE99LIMIT  means the line number limit of C99  */
#define LINE99LIMIT         0x7FFFFFFF

/*
 * STDC     might be set to 1, if COMPILER conforms to the Standard, else
 *      be set to 0.
 *      This macro is used for the predefined __STDC__, when MODE ==
 *      STANDARD.
 *          (STDC >= 1) disables predefined macros not beginning with '_'.
 * STDC_VERSION     is used for the value of __STDC_VERSION__.
 * STDC_HOSTED      is used for the value of __STDC_HOSTED__.
 */
#if     ! HAVE_UNSIGNED_LONG || IDMAX < IDLEN90MIN || NBUFF < SLEN90MIN + 3
#define STDC                0
#else
#if     NWORK < SLEN90MIN + 2 || NMACPARS < NMACPARS90MIN
#define STDC                0
#else
#if     NEXP < EXP_NEST90MIN || BLK_NEST < BLK_NEST90MIN
#define STDC                0
#endif
#endif
#endif
#ifndef STDC
#define STDC                1       /* 1 : for ISO 9899:1990 or later   */
#endif
#ifndef STDC_VERSION
#define STDC_VERSION        0L      /* 199409L  : For conforming
            implementation to ISO 9899:1990 / Amendment 1:1995
            199901L : For C99   */
#endif
#ifndef STDC_HOSTED
#define STDC_HOSTED         1       /* 1 : for hosted implementation,
            0 : for free-standing implementation (C99 specification)    */
#endif

/*
 * CPLUS specifies the default value of the pre-defined macro __cplusplus
 * for C++ processing.
 * The value can be changed by -V<n> option.
 */
#define CPLUS               1       /* 199711L for C++ Standard     */

#endif  /* MODE == STANDARD */

