<?php
// This script shows details on movies

$global_prefs = $mm->getGlobalPrefs();


if ( is_numeric($_GET['id']) ) {
   $id = $_GET['id'];
   
   $sql = "SELECT * FROM movies_list WHERE movie_id = ?";
   $result = $mm->dbExec($sql, array($id));
   list($movie_id, $movie_title, $movie_director, $year_released, 
      $movie_genre, $running_time, $starring_actors, $movie_synopsis, 
      $borrower_uid, $date_due_back, $movie_format, $movie_region, 
      $reserved_uid, $imdb_url) = $mm->dbFetchRow($result);

   $movie_title = stripslashes($movie_title);
   $starring_actors = stripslashes($starring_actors);
   $movie_synopsis = stripslashes($movie_synopsis);

?>

<p class="subheading">

<?php 
   echo "{$module_text['detailsonmovie']} - <i>$movie_title</i>";
?>

</p>

<?php

   // If user is level 2 or higher, show admin box
   if ($_SESSION['level'] > '1') {
?>

<table class="admin">
   <tr>
      <td>
         <form action="index.php" method="get">
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="history">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="image" src="modules/movies/gfx/history.png" 
               border="0" alt="<?php echo $module_text['historytooltip'];?>" 
               title="<?php echo $module_text['historytooltip'];?>">
         </form>
      </td>
      
<?php
      // If the user is level 3, show the edit/delete buttons
      if ($_SESSION['level'] > '2') {
?>
            
      <td>
         <form action="index.php" method="get">
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="edit">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="image" src="modules/movies/gfx/edit.png" border="0" 
               alt="<?php echo $module_text['editmovietooltip'];?>" 
               title="<?php echo $module_text['editmovietooltip'];?>">
         </form>
      </td>
      <td>
         <form action="index.php" method="post"
            onSubmit="
            if(confirm('<?php echo $module_text['deletemovieconfirm']; ?>')) {
               return true
            } else {
               return false }
            ">
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="delete">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="image" src="modules/movies/gfx/delete.png" border="0" 
               alt="<?php echo $module_text['deletemovietooltip'];?>" 
               title="<?php echo $module_text['deletemovietooltip'];?>">
         </form>
      </td>

<?php
      //  End of level three buttons
      };
?>
   </tr>
</table>

<br/>

<?php
   // End of admin box
   };
?>

<table class="main">
   <!-- Nesting some tables so the cover art is on the left, 
      details on the right -->
   <tr>
      <td valign="top">
      
<?php
   if (file_exists("modules/movies/covers/$id")) {
      $image_details = getimagesize("modules/movies/covers/$id");
      list($width, $height, $type, $string) = $image_details;

      if ($height > "300") {
         $h_fraction = 300/$height;
         $new_width = round(($width*$h_fraction),0);
         echo "<img src=\"modules/movies/covers/$id\"";
         echo " height=\"300\" width=\"$new_width\" alt=\"Cover Art\">";
      } else {
         echo "<img src=\"modules/movies/covers/$id\"";
         echo " {$image_details[3]} alt=\"Cover Art\">";
      };
   } else {
      echo "<img src=\"modules/movies/covers/no_cover.png\"";
      echo " alt=\"{$module_text['nocoverart']}\">";
   };
?>

      </td>
      <td valign="top">
         <!-- Movie details nested table -->
         <table>
            <tr>
               <td align="right" width="20%">
                  <p class="mainlabel">
            
<?php 
   echo $module_text['director'], "&nbsp;&nbsp;\n";
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">
               
<?php
   $directors = explode(", ", $movie_director);
   while (list($key, $val) = each($directors)) {
      if (is_array($val)) {
         continue;
      } else {
         if ($first_director) {
            echo ", ";
         };
         echo "<a href=\"index.php?module=movies&do=search&director=$val\"";
         echo " title=\"{$module_text['directorsearchtooltip']}\">$val</a>";
         $first_director = "done";
      };
   };
?>

                  </p>
               </td>
            </tr>

            <tr>
               <td align="right">
                  <p class="mainlabel">
               
<?php 
   echo $module_text['format'], "&nbsp;&nbsp;\n";
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">
               
<?php
   require("modules/movies/lang/$lang.lists/formats.php");
   while (list($key, $val) = each($formats_list)) {
      if ($key == $movie_format) {
         echo "<a href=\"index.php?module=movies&do=search&format=$key\"";
         echo " title=\"{$module_text['formatsearchtooltip']}\">$val</a>\n";
      };
   };
?>

                  </p>
               </td>
            </tr>
            <tr>
               <td align="right">
                  <p class="mainlabel">
               
<?php 
   echo $module_text['region'], "&nbsp;&nbsp;\n";
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">
               
<?php
   require("modules/movies/lang/$lang.lists/regions.php");
   while (list($key, $val) = each($regions_list)) {
      if ($key == $movie_region) {
         echo "<a href=\"index.php?module=movies&do=search&region=$key\"";
         echo " title=\"{$module_text['regionsearchtooltip']}\">$val</a>\n";
      };
   };
?>

                  </p>
               </td>
            </tr>

            <tr>
               <td align="right">
                  <p class="mainlabel">
               
<?php 
   echo $module_text['genre'], "&nbsp;&nbsp;\n";
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">
               
<?php
   // Get the list of genres in the native language
   require("modules/movies/lang/$lang.lists/genres.php");

   // Split up the genres from the db
   $genres = explode(", ", $movie_genre);

   while (list($key, $val) = each($genres)) {
      if (is_array($val)) {
         continue;
      } else {
         if ($first_genre == "done") {
            echo ",\n";
         };
         $val = trim($val);
         echo "<a href=\"index.php?module=movies&do=search&genre=$val\"";
         echo " title=\"{$module_text['genresearchtooltip']}\">";
         echo " {$genres_list[$val]}</a>";
         $first_genre = "done";
      };
   };
?>

                  </p>
               </td>
            </tr>

            <tr>
               <td align="right">
                  <p class="mainlabel">
               
<?php 
   echo $module_text['year'], "&nbsp;&nbsp;\n";
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">
<?php 
   echo "<a href=\"index.php?module=movies&do=search&year=$year_released\"";
   echo " title=\"{$module_text['yearsearchtooltip']}\">$year_released</a>";
?>

                  </p>
               </td>
            </tr>

            <tr>
               <td align="right">
                  <p class="mainlabel">
               
<?php 
   echo $module_text['runningtime'], "&nbsp;&nbsp;\n";
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">

<?php 
   echo "$running_time {$module_text['minutes']}";
?>

                  </p>
               </td>
            </tr>

            <tr>
               <td align="right">
                  <p class="mainlabel">
               
<?php 
   echo $module_text['actors'], "&nbsp;&nbsp;\n";
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">
               
<?php
   // This  splits the starring_actors into seperate links for searching.

   $actors = explode(", ", $starring_actors);
   while (list($key, $val) = each($actors)) {
      if (is_array($val)) {
         continue;
      } else {
         if ($first_actor) {
            echo ", ";
         };
         echo "<a href=\"index.php?module=movies&do=search&actor=$val\"";
         echo " title=\"{$module_text['actorsearchtooltip']}\">$val</a>";
         $first_actor = "done";
      };
   };
?>

                  </p>
               </td>
            </tr>

            <tr>
               <td align="right" valign="top">
                  <p class="mainlabel">

<?php 
   echo $module_text['synopsis'], "&nbsp;&nbsp;\n"
?>

                  </p>
               </td>
               <td>
                  <p class="maintext">

<?php 
   echo "$movie_synopsis";
?>

                  </p>
               </td>
            </tr>
         
<?php
   // If there is an imdb link available, show it
   if ($imdb_url AND $global_prefs['online'] == "on") {
?>

            <tr>
               <td>
               </td>
               <td>
                  <p class="maintext">
                     <br/><br/>

<?php 
      echo "<a href=\"$imdb_url\" target=\"new\">";
      echo "{$module_text['infoatimdb']}</a>";
?>
                  </p>
               </td>
            </tr>

<?php
   };
?>

         </table>
<!-- End of the nested table for movie details -->

      </td>
   </tr>
</table>
<br/><br/>

<?php
   // Things to do depending on whether the movie is borrowed/not, 
   // and reserved/not.
?>

<table class="admin" cellpadding="4" border="0">

<?php 
   // If the movie is out
   if (is_numeric ($borrower_uid)) {
                     
      // If the viewer is level 2 or 3, we show them more info
      if ($_SESSION['level'] > '1') {
?>

   <tr>
      <td align="right">
         <p class="adminlabel"><?php echo $module_text['borrowedby'];?></p>
      </td>
      <td>
      
<?php 
         // Show the borrower
         $sql = "SELECT user_name, real_name FROM global_users 
            WHERE user_id = '$borrower_uid'";
         $result = $mm->dbExec($sql);
         list($user_name, $real_name) = $mm->dbFetchRow($result);

         // If level 2 or higher
         if ($_SESSION['level'] > '1') {
            echo "<p class=\"admintext\">";
            echo "<a href=\"details.php?id=$borrower_uid\">";
            echo "$real_name</a> ($user_name)</p>";
         } else {
            echo "$real_name";
         };
?>

      </td>
   </tr>
   
<?php
      };
?>

   <tr>
      <td align="right">
      
<?php 
      echo "<p class=\"adminlabel\">{$module_text['duebackby']}</p>";
?>

      </td>
      <td>
      
<?php
      // Make the due date readable
      $due_back = date("l, j M Y", $date_due_back);

      // Check if it's overdue.  if so, make the date red
      if ($date_due_back < date("U")) {
         echo "<p class=\"admintext\"";
         echo " style=\"color:#ff0000;font-weight:bold\">$due_back</p>";
      } else {
         echo "<p class=\"admintext\">$due_back</p>";
      };
?>

      </td>

<?php
      // If the viewer is level 2 or 3
      if ($_SESSION['level'] > '1') {
?>

      <td>
         <form action="index.php" method="post">
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="modify">
            <input type="hidden" name="action" value="return">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="hidden" name="uid" 
               value="<?php echo "$borrower_uid";?>">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['return'];?>">
         </form>
      </td>
      
<?php
      };
?>

   </tr>
   
<?php
      // If the movie is reserved, say so
      if (is_numeric($reserved_uid)) {
?>

   <tr>
      <td colspan="3">
         <hr/>
      </td>
   </tr>
   <tr>
      <td align="right">
         <p class="adminlabel">

<?php 
         echo $module_text['reservedfor'];
?>

         </p>
      </td>
      <td>

<?php
         $sql = "SELECT user_name, real_name FROM global_users 
            WHERE user_id = '$reserved_uid'";
         $result = $mm->dbExec($sql);
         list($user_name, $real_name) = $mm->dbFetchRow($result);
         if ($_SESSION['level'] > '1') {
            echo "<p class=\"admintext\">";
            echo "<a href=\"details.php?id=$reserved_uid\">$real_name</a>";
            echo " ($user_name)</p>";
         } else {
            echo "$real_name";
         };
?>

      </td>

<?php
         //  If the viewer is level 2 or 3
         if ($_SESSION['level'] > '1') {
?>

      <td>
         <form action="index.php" method="post">
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="modify">
            <input type="hidden" name="action" value="cancelres">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['cancelres'];?>">
         </form>
      </td>
      
<?php
         };
?>

   </tr>
   <tr>
      <td colspan="3" align="center">
         <form action="" method="get" onSubmit="
            window.open('modules/movies/help.php?page=borrowing','Help', 'width=450,height=350,toobar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1'); 
            return false">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['showhelp'];?>">
         </form>
      </td>
   </tr>

<?php
      // If the movie isn't reserved, and the viewer is level 2 or 3, 
      // show the reservation form
      } elseif (! is_numeric($reserved_uid) AND $_SESSION['level'] > '1') {
?>

   <tr>
      <td colspan="3">
         <hr/>
      </td>
   </tr>
   <tr>
      <td align="right">
         <p class="adminlabel">

<?php 
         echo $module_text['reservethisfor'];
?>

         </p>
      </td>
      <form action="index.php" method="post">
         <td>

<?php
         $sql = "SELECT * FROM global_users WHERE user_name != 'super' 
            ORDER BY real_name";
         $result = $mm->dbExec($sql);
         echo "<select class=\"adminlist\" name=\"uid\">";
         while ($row = $mm->dbFetchArray($result)) {
            $uid = $row['user_id'];
            $real_name = $row['real_name'];
            $user_name = $row['user_name'];
            echo "\n<option value=\"$uid\">$real_name ($user_name)</option>";
      };
      echo "</select>";
?>

         </td>
         <td>
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="modify">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="hidden" name="action" value="reserve">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['reserve'];?>">
         </td>
      </form>
   </tr>
   <tr>
      <form action="" method="get" 
         onSubmit="window.open('modules/movies/help.php?page=borrowing',
            'Help', 'width=450,height=350,toobar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1'); 
         return false">
         <td colspan="3" align="center">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['showhelp'];?>">
         </td>
      </form>
   </tr>
   
<?php
      };

   // If movie is available, show a different set of options
   } else {
                     
      // If the movie isn't reserved, show the full dropdown list of borrowers
      // And the dropdown list to reserve as well
      // Also check if the viewer has level 2 or 3
      if (! is_numeric($reserved_uid) AND $_SESSION['level'] > '1') {
?>

   <tr>
      <td align="right">
         <p class="adminlabel">

<?php 
      echo $module_text['borrowthis'];
?>

         </p>
      </td>

      <form name="borrow_form" action="index.php" method="post">
         <input type="hidden" name="module" value="movies">
         <input type="hidden" name="do" value="modify">
         <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
         <input type="hidden" name="action" value="borrow">

         <td colspan="3">

<?php
      $sql = "SELECT * FROM global_users WHERE user_name != 'super' 
         ORDER BY real_name";
      $result = $mm->dbExec($sql);
      echo "<select class=\"adminlist\" name=\"uid\">";
      while ($row = $mm->dbFetchArray($result)) {
         $uid = $row['user_id'];
         $real_name = $row['real_name'];
         $user_name = $row['user_name'];
         echo "\n<option value=\"$uid\">$real_name ($user_name)</option>";
      };
      echo "</select>";
?>

         </td>
   </tr>

   <tr>
      <td align="right">
         <p class="adminlabel">

<?php 
      echo $module_text['datedueback'];
?>

         </p>
      </td>

<?php
      // Find out the default date due back
      $sql = "SELECT value FROM movies_prefs WHERE name = 'overdue'";
      $result = $mm->dbExec($sql);
      list($overdue_pref) = $mm->dbFetchRow($result);
      $today = date("j-M-Y");
      $plus_pref = strtotime("$today + $overdue_pref days");
      $due_back = date("j-M-Y", $plus_pref);
?>

      <td align="left" width="11">
         <input class="admintext" type="text" name="date_due_back" 
            size="11" onfocus="this.blur()" value="<?php echo "$due_back";?>">
      </td>
      <td align="left" width="16">
      <a href="javascript: void(0);" onmouseover="if (timeoutId) clearTimeout(timeoutId);window.status='Show Calendar';return true;" onmouseout="if (timeoutDelay) calendarTimeout();window.status='';" onclick="g_Calendar.show(event,'borrow_form.date_due_back', false, 'dd-mmm-yyyy', new Date()); return false;"><img src="modules/movies/gfx/calendar.png" name="imgCalendar" border="0" alt="<?php echo $module_text['selectdate'];?>" title="<?php echo $module_text['selectdate'];?>"></a>
      </td>
      <td>
         <input class="adminbutton" type="submit" value="<?php echo $module_text['borrow'];?>">

      </td>
      
      </form>
      
   </tr>
   <tr>
      <td colspan="5" align="center">
         <hr/>
      </td>
   </tr>
   <tr>
      <td align="right">
         <p class="adminlabel">
         
<?php 
      echo $module_text['reservethisfor'];
?>

         </p>
      </td>
      <form action="index.php" method="post">
         <td colspan="2">

<?php
      $sql = "SELECT * FROM global_users WHERE user_name != 'super' 
         ORDER BY real_name";
      $result = $mm->dbExec($sql);
      echo "<select class=\"adminlist\" name=\"uid\">";
      while ($row = $mm->dbFetchArray($result)) {
         $uid = $row['user_id'];
         $real_name = $row['real_name'];
         $user_name = $row['user_name'];
         echo "\n<option value=\"$uid\">$real_name ($user_name)</option>";
      };
      echo "</select>";
?>

         </td>
         <td>
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="modify">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="hidden" name="action" value="reserve">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['reserve'];?>">

         </td>
      </form>
   </tr>
   <tr>
      <form action="" method="get" onSubmit="window.open('modules/movies/help.php?page=borrowing','Help', 'width=450,height=350,toobar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1'); return false">
         <td colspan="5" align="center">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['showhelp'];?>">
         </td>
      </form>
   </tr>
   
<?php
      // If the movie IS reserved, show only the reserver in the borrower list
      // and a cancel reservation button
      } elseif ( is_numeric ($reserved_uid) AND $_SESSION['level'] > '1') {
?>

   <form name="borrow_form" action="index.php" method="post">
      <tr>
         <td align="right">
            <p class="adminlabel">

<?php 
      echo $module_text['borrowthis'];
?>

            </p>
         </td>
         <td>
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="modify">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="hidden" name="action" value="borrow">
            <select class="adminlist" name="uid">

<?php
      $sql = "SELECT real_name FROM global_users 
         WHERE user_id = '$reserved_uid'";
      $result = $mm->dbExec($sql);
      list($real_name) = $mm->dbFetchRow($result);
      echo "<option value=\"$reserved_uid\">$real_name</option>";
?>

            </select>
         </td>
      </tr>
      <tr>
         <td align="right">
            <p class="adminlabel"><?php echo $module_text['datedueback'];?></p>
         </td>
         
<?php
      // Find out the default date due back
      $sql = "SELECT value FROM movies_prefs WHERE name = 'overdue'";
      $result = $mm->dbExec($sql);
      list($overdue_pref) = $mm->dbFetchRow($result);
      $today = date("j-M-Y");
      $plus_pref = strtotime("$today + $overdue_pref days");
      $due_back = date("j-M-Y", $plus_pref);
?>

         <td align="right">
            <input class="admintext" type="text" name="date_due_back" 
               size="11" onfocus="this.blur()" 
               value="<?php echo "$due_back";?>">
         </td>
         <td align="left">
            <a href="javascript: void(0);" onmouseover="if (timeoutId) clearTimeout(timeoutId);window.status='Show Calendar';return true;" onmouseout="if (timeoutDelay) calendarTimeout();window.status='';" onclick="g_Calendar.show(event,'borrow_form.date_due_back', false, 'dd-mmm-yyyy', new Date()); return false;"><img src="modules/movies/gfx/calendar.png" name="imgCalendar" border="0" alt=""></a>

            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['borrow'];?>">
         </td>
      </tr>
   </form>

   <tr>
      <form action="index.php" method="post">
         <td colspan="2" align="right">
            <input type="hidden" name="module" value="movies">
            <input type="hidden" name="do" value="modify">
            <input type="hidden" name="id" value="<?php echo "$movie_id";?>">
            <input type="hidden" name="action" value="cancelres">
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['cancelres'];?>">
         </td>
      </form>
      <form action="" method="get" onSubmit="window.open('modules/movies/help.php?page=borrowing','Help', 'width=450,height=350,toobar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1'); return false">
         <td>
            <input class="adminbutton" type="submit" 
               value="<?php echo $module_text['showhelp'];?>">
         </td>
      </form>
   </tr>
   
<?php
      // If the viewer isn't level 2 or 3 simply show a message
      } elseif (is_numeric($reserved_uid)) {
?>

   <tr>
      <td>

<?php 
      echo $module_text['moviereserved'];
?>

      </td>
   </tr>

<?php
      } elseif (!is_numeric($borrower_uid)) {
?>

   <tr>
      <td>

<?php 
      echo $module_text['movieavailable'];
?>

      </td>
   </tr>
                     
<?php
      // End of stuff to do whether or not the movie is reserved.
      };

// End of movie details section
   };

?>

</table>

<?php
};
?>
