;; $Id: mell-split.el,v 1.1.1.1 2003/06/01 03:04:44 komatsu Exp $
;; 
;; !!! BETA VERSION !!!

(defun mell-split-string (string &optional delimiter strict-space-p)
  (setq delimiter (or delimiter ","))
  (let ((queue "") split-list open-p)
    (mapcar
     '(lambda (substr)
	(cond
	 (open-p
	  (cond
	   ((mell-split-string-close-quoted-p substr)
	    (setq split-list (cons (concat queue substr) split-list))
	    (setq queue "")
	    (setq open-p nil)
	    )
	   (t
	    (setq queue (concat queue substr delimiter))
	    )))
	 (t ;; not open-p
	  (cond
	   ((mell-split-string-open-quoted-p substr)
	    (setq queue (concat queue substr delimiter))
	    (setq open-p t)
	    )
	   ((mell-split-string-quoted-p substr)
	    (setq queue (concat queue substr delimiter))
	    )
	   (t
	    (setq split-list (cons (concat queue substr) split-list))
	    (setq queue "")
	    )))
	 ))
     (split-string string (if strict-space-p
			      delimiter
			    (concat "[ \t]*" delimiter "[ \t]*")))
     )
    (if (string= queue "")
	(reverse split-list)
      (error "mell-sprlit-string: Syntax Error"))
    ))

(defun mell-split-string-open-quoted-p (string &optional open-str)
  (setq open-str (or open-str "\""))
  (save-match-data
    (string-match (concat "^" (regexp-quote open-str)) string)
    ))

(defun mell-split-string-close-quoted-p (string &optional close-str)
  (setq close-str (or close-str "\""))
  (save-match-data
    (and (string-match (concat (regexp-quote close-str) "$") string)
	 (not (mell-split-string-backslash-quoted-p (substring string 0 -1))))
    ))

(defun mell-split-string-backslash-quoted-p (string)
  (save-match-data
    (and (string-match "\\(\\\\\\)+$" string)
	 (eq (% (length (substring string (match-beginning 0))) 2) 1))
    ))

(defun taiyaki (begin end)
  (interactive "r")
  (setq string (buffer-substring begin end))
  (mapcar
   '(lambda (x)
      (insert x "\n"))
   (setq aaa (mell-split-string string)))
  )
