# Artist: Pink Floyd
# Album: Wish you were here
# Song: Wish you were here

@head {
	$time_sig 4/4
	$tempo 120
	$title "Pink Floyd - wish you were here"
}

@body {

	# bass notes on piano

	%define g_riff { /l4/g3 /l8/a b /l4/d4 /l1/e /l4/r }
	%define em_riff { /l4/e4 g e /l1/d /l4/r }
	%define a_riff { /l4/e4 d b3 /l1/a /l4/r }

	@channel 1 piano {
		$patch 2
		/l4r5/r # rest for count in
		%repeat 4 {
			%repeat 2 { ~g_riff ~em_riff }
			%repeat 2 { ~g_riff ~a_riff }
			/l2/r /l4/r
                        $length 1 %repeat 3 { ( g3 b d4 ) }
                        /l8/g3 /l8/r
		}
	}

	# lead acoustic guitar

	@channel 2 "acoustic guitar" {
		$patch 27
		/l4r5/r # rest for count in
		%repeat 4 {
			/l1/r /l8/a4 b /l2/d5 /l8/e b4 /l2/d5
			/l16/b4 a /l16/g /l2/d /l32/r /l4/r
			/l32/a+3 /l8/b d4 /l4/d 
			/l1/r ( /l4/e5 a ) ( /l8/d g ) r 
			( /l4/a4 d5 ) ( /l8/b4 e5 ) r ( a4 d5 ) r ( b4 e5 ) r
			/l8/a4 g /l1/g3 /l4/r
			/l1/r /l8/a4 b d5 b4 e5 /l2/r

			%bend e5 { 
				64+32 # bend up to f+
				7:64-32 # back down to e
				8+0 # hold for 1/8
			}
				
			/l8/d e r /l2/a4
			
			%bend b4 {
				64+8 # bend up 1/2 a step
				7:64+0 # hold
			}

			/l8/r d5 e 

			%bend b4 { 64+8 7:64+0 } # same as previous bend

			r /l4/a
			/l4r3/r /l8/a4 b d5 b4 e5 /r3/r 

			%bend e5 { 64+32 7:64+0 }

			/l8/r /l8/e d e r /l1/a4
			/l2/r /l8/b a g 
			/l1r3/r /l3:8/r # rest before repeat
		}
	}

	# click

	@channel 10 click {
		/l4r340/c+3
	}
}
