#ifndef LEVEL_SELECT_MENU_H
#define LEVEL_SELECT_MENU_H

#include "Menu.h"
#include "ReplaceableSurfaceWidget.h"


class LevelSelectorMenu : public Menu
{
    friend class MissionSelectWidget;

    MENU_SINGLETON(LevelSelector);

  public:
    void eventShow();
    void eventHide();

    const std::string &getCurrentlySelected() const
    {
        return m_levelNames[m_selectedIndex];
    }

    const std::string &getCurrentlySelectedFull() const
    {
        return m_fullLevelNames[m_selectedIndex];
    }

  protected:

    PARAGUI_CALLBACK(onMissionSelected);
    PARAGUI_CALLBACK(onGo);
    PARAGUI_CALLBACK(onHighscore);
    PARAGUI_CALLBACK(onBack);
    PARAGUI_CALLBACK(onPreviousLevel);
    PARAGUI_CALLBACK(onNextLevel);
    PARAGUI_CALLBACK(onFirstLevel);
    PARAGUI_CALLBACK(onLastLevel);

    void createPreview();
    void updateLevelSelection();

  private:

    void initMissionSelect();

    ReplaceableSurfaceWidget *m_previewWidget;

    std::vector<std::string> m_levelNames;
    std::vector<std::string> m_fullLevelNames;
    std::vector<size_t> m_numberOfLevels;
    long m_selectedIndex;
};

#endif // LEVEL_SELECT_MENU_H
