//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: mididev.cpp,v 1.1.1.1 2003/10/29 10:06:13 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <config.h>

#include <stdio.h>
#include <unistd.h>
#include <errno.h>

#include "midictrl.h"
#include "song.h"
#include "midi.h"
#include "midiport.h"
#include "mididev.h"
#include "minstrument.h"
#include "config.h"
#include "mpevent.h"

#ifdef MIDI_DRIVER_MIDI_SERIAL
extern void initMidiSerial();
#endif
extern void initMidiAlsa();

MidiDeviceList midiDevices;

//---------------------------------------------------------
//   init
//---------------------------------------------------------

void MidiDevice::init()
      {
      _rwFlags   = 0;
      _masterVol = 16383;
      _port      = -1;
      }

int MidiDevice::rwFlags() const
      {
      return _rwFlags;
      }
void MidiDevice::setrwFlags(int val)
      {
      _rwFlags = val;
      }

//---------------------------------------------------------
//   MidiDevice
//---------------------------------------------------------

MidiDevice::MidiDevice()
      {
      init();
      }

MidiDevice::MidiDevice(const QString& n)
   : _name(n)
      {
      init();
      }

MidiDevice::~MidiDevice()
      {
      }

//---------------------------------------------------------
//   setMasterVol
//---------------------------------------------------------

void MidiDevice::setMasterVol(int val)
      {
      _masterVol = val;
      unsigned char data[6] = { 0x7f, 0x7f, 0x04, 0x01, 0x00, 0x00 };
      data[4] = val & 0x7f;
      data[5] = (val >> 7) & 0x7f;
      MidiPlayEvent event(0, data, 6);
      putEvent(&event);
      }

//---------------------------------------------------------
//   find
//---------------------------------------------------------

MidiDevice* MidiDeviceList::find(const QString& s)
      {
      for (iMidiDevice i = begin(); i != end(); ++i)
            if ((*i)->name() == s)
                  return *i;
      return 0;
      }

//---------------------------------------------------------
//   initMidiDevices
//---------------------------------------------------------

void initMidiDevices()
      {
#ifdef MIDI_DRIVER_MIDI_SERIAL
      initMidiSerial();
#endif
      initMidiAlsa();
      }

