#include <qmessagebox.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <stdio.h>
#include "mainwindow.h"
#include "mdiwindow.h"
#include "query.h"
#include "multilinelistviewitem.h"
#include "querylistview.h"

void MainWindow::slot_query()
{
	slot_query(database->currentText(), query->currentText());
}

void MainWindow::slot_query(const QString &database, const QString &query)
{
	slot_query(database, query, "");
}

void MainWindow::slot_query(const QString &database, const QString &query, const QString &title)
{
	if(query.isEmpty())
		return;

	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
  
	if(title.length() == 0)
		s->setCaption(tr("Query") + QString(" - ") + query);
	else
		s->setCaption(title + QString(" - ") + query);

	QueryListView *sql = new QueryListView(s->menuBar(), s->statusBar(), &mysql, &option, s);

	sql->set_sql(database, query);

	connect(sql, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query2(const QString &, const QString &)));

	switch(sql->execute())
	{
		case SQL_ERROR:
			statusBar()->message(QString::fromLocal8Bit(mysql_error(&mysql)), 3000);
			return;
		case SQL_SCHEMA:
			slot_schema();
			return;
		case SQL_NOSCHEMA:
			return;
	}

	 if(is_sql_exist(query) == FALSE)
     {
		 QString sql = this->query->currentText();
         this->query->insertItem(query);
         this->query->lineEdit()->setText(sql);
     }

	s->setCentralWidget(sql);

	if(sql->sizeHint().width() + 5 > workspace->width())
	{
		if(sql->sizeHint().height() > 200)
		{
			s->resize(workspace->width() - 350, 200);
		}
		else
		{
			s->resize(workspace->width() - 350, sql->sizeHint().height());
		}
	}
	else
	{
		if(sql->sizeHint().height() > 200)
		{
			s->resize(sql->sizeHint().width() + 5, 200);
		}
		else
		{
			s->resize(sql->sizeHint().width() + 5, sql->sizeHint().height());
		}
	}

	//slot_schema();

	QPopupMenu *z = new QPopupMenu();
	
	z->insertItem(tr("&Save"), sql, SLOT(slot_save()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ose"), sql, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);
	
	if(sql->is_select())
	{
		z = new QPopupMenu();
		z->insertItem(tr("&Insert"), sql, SLOT(slot_insert(int)));
		z->insertItem(tr("&Update"), sql, SLOT(slot_update(int)));
		z->insertItem(tr("&Delete"), sql, SLOT(slot_delete(int)));
		z->insertSeparator();
		z->insertItem(tr("Select &All"), sql, SLOT(slot_select_all(int)));
		z->insertItem(tr("Select &None"), sql, SLOT(slot_select_none(int)));
		z->insertSeparator();
		z->insertItem(tr("R&eload"), sql, SLOT(slot_reload()));
		s->menuBar()->insertItem(tr("&Tools"), z);
	}

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->show();
}

void MainWindow::slot_query2(const QString &sql, const QString &database)
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
	
	Query *query = new Query(&mysql, &option, s);
	query->slot_database(database);
	query->slot_sql(sql, TRUE);

	connect(query, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query(const QString &, const QString &)));
	connect(query->sql2, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query2(const QString &, const QString &)));
	connect(query, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

    s->setCentralWidget(query);

	s->setCaption(tr("Query"));
   
	//
	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), query, SLOT(slot_fire()), Key_F5);
	z->insertItem(tr("&Save"), query->sql2, SLOT(slot_save()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ose"), query, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);

	z = new QPopupMenu();
	z->insertItem(tr("&Undo"), query, SLOT(slot_undo()), CTRL+Key_U);
	z->insertItem(tr("&Redo"), query, SLOT(slot_redo()), CTRL+Key_R);
	z->insertSeparator();
	z->insertItem(tr("&Cut"), query, SLOT(slot_cut()), CTRL+Key_X);
	z->insertItem(tr("C&opy"), query, SLOT(slot_copy()), CTRL+Key_C);
	z->insertItem(tr("&Paste"), query, SLOT(slot_paste()), CTRL+Key_V);
	z->insertItem(tr("&Delete"), query, SLOT(slot_delete()), Key_Delete);
	z->insertItem(tr("Select &All"), query, SLOT(slot_select_all()), CTRL+Key_A);
	s->menuBar()->insertItem(tr("&Edit"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("&Load Query"), query, SLOT(slot_import()));
	z->insertItem(tr("&Save Query"), query, SLOT(slot_export()));
	z->insertSeparator();
	z->insertItem(tr("Load from &Clipboard "), query, SLOT(slot_clipboard()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ear Query"), query, SLOT(slot_clear_query()));
	//z->insertSeparator();
	//z->insertItem(tr("&Options..."), query->sql2, SLOT(slot_option()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), query, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->resize(480,331);
	s->show();

}

void MainWindow::slot_query2(int)
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
	
	Query *query = new Query(&mysql, &option, s);

	query->slot_database(hay->text(0));

	connect(query, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query(const QString &, const QString &)));
	connect(query->sql2, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query2(const QString &, const QString &)));
	connect(query, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

    s->setCentralWidget(query);

	s->setCaption(tr("Query"));
   
	//
	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), query, SLOT(slot_fire()), Key_F5);
	z->insertItem(tr("&Save"), query->sql2, SLOT(slot_save()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ose"), query, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);

	z = new QPopupMenu();
	z->insertItem(tr("&Undo"), query, SLOT(slot_undo()), CTRL+Key_U);
	z->insertItem(tr("&Redo"), query, SLOT(slot_redo()), CTRL+Key_R);
	z->insertSeparator();
	z->insertItem(tr("&Cut"), query, SLOT(slot_cut()), CTRL+Key_X);
	z->insertItem(tr("C&opy"), query, SLOT(slot_copy()), CTRL+Key_C);
	z->insertItem(tr("&Paste"), query, SLOT(slot_paste()), CTRL+Key_V);
	z->insertItem(tr("&Delete"), query, SLOT(slot_delete()), Key_Delete);
	z->insertItem(tr("Select &All"), query, SLOT(slot_select_all()), CTRL+Key_A);
	s->menuBar()->insertItem(tr("&Edit"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("&Load Query"), query, SLOT(slot_import()));
	z->insertItem(tr("&Save Query"), query, SLOT(slot_export()));
	z->insertSeparator();
	z->insertItem(tr("Load from &Clipboard "), query, SLOT(slot_clipboard()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ear Query"), query, SLOT(slot_clear_query()));
	//z->insertSeparator();
	//z->insertItem(tr("&Options..."), query->sql2, SLOT(slot_option()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), query, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->resize(480,331);
	s->show();
}

void MainWindow::slot_query2()
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
	
	Query *query = new Query(&mysql, &option, s);

	connect(query, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query(const QString &, const QString &)));
	connect(query->sql2, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query2(const QString &, const QString &)));
	connect(query, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	
    s->setCentralWidget(query);

	s->setCaption(tr("Query"));
   
	//
	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), query, SLOT(slot_fire()), Key_F5);
	z->insertItem(tr("&Save"), query->sql2, SLOT(slot_save()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ose"), query, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);

	z = new QPopupMenu();
	z->insertItem(tr("&Undo"), query, SLOT(slot_undo()), CTRL+Key_U);
	z->insertItem(tr("&Redo"), query, SLOT(slot_redo()), CTRL+Key_R);
	z->insertSeparator();
	z->insertItem(tr("&Cut"), query, SLOT(slot_cut()), CTRL+Key_X);
	z->insertItem(tr("C&opy"), query, SLOT(slot_copy()), CTRL+Key_C);
	z->insertItem(tr("&Paste"), query, SLOT(slot_paste()), CTRL+Key_V);
	z->insertItem(tr("&Delete"), query, SLOT(slot_delete()), Key_Delete);
	z->insertItem(tr("Select &All"), query, SLOT(slot_select_all()), CTRL+Key_A);
	s->menuBar()->insertItem(tr("&Edit"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("&Load Query"), query, SLOT(slot_import()));
	z->insertItem(tr("&Save Query"), query, SLOT(slot_export()));
	z->insertSeparator();
	z->insertItem(tr("Load from &Clipboard "), query, SLOT(slot_clipboard()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ear Query"), query, SLOT(slot_clear_query()));
	//z->insertSeparator();
	//z->insertItem(tr("&Options..."), query->sql2, SLOT(slot_option()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), query, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->resize(480,331);
	s->show();
}

bool MainWindow::is_sql_exist(const QString &sql)
{
	for(int z = 0; z < query->count(); z++)
		if(query->text(z).stripWhiteSpace() == sql.stripWhiteSpace())
			return TRUE;

	return FALSE;
}
