#ifndef UTILITY_H
#define UTILITY_H

#include <qstring.h>
#include <qlist.h>
#include <qmap.h>

#define TARGET_NONE							-1
#define TARGET_MYSQL							0
#define TARGET_MSQL							1
#define TARGET_POSTGRESQL			2

class SQL_VALUE
{
public:
	SQL_VALUE();
	~SQL_VALUE();

	QList<QString> *field;
	QList<QString> *data;
};

class SQL_RESULT
{
public:
	SQL_RESULT();
	~SQL_RESULT();

	SQL_VALUE value;
};

class SQL 
{
public:
	SQL();
	~SQL();
	static QString strip_comment(const char *sql);
	static QList<QString> split_sql(const char *sql);

	static int sql_query(const char *);
	static void sql_free_result(void *);

	bool sql_init(int flag);
	bool sql_connect(const char *host, const char *user, const char *password, const char *database = NULL, unsigned int port = 0, const char *socket = NULL, unsigned int flag = 0);
	bool sql_connect(QMap<QString, QString>);
	void sql_close();
	SQL_RESULT* sql_store_result();	
	unsigned int sql_num_fields(SQL_RESULT *);
	unsigned int sql_num_rows(SQL_RESULT *);
	SQL_RESULT* sql_list_dbs();
	int sql_select_db(const char *);
private:
	int target;
};

#endif
