<?php
# $Id: importer.php,v 1.8 2002/07/01 06:57:48 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","importer");
define("PAGE_TITLE","Importer");

require_once("local.inc");
include_once(NGT_LIB."head.inc");

if( !isset($action) ) $action = "";
if( !is_array($files) ) $files = array();
$totalcount = 0;

# Try to get the nagios.cfg from previous import
$nagioscfg = PluginGetConfig("nagioscfg");

if( $action == "importobjects" ) {

	print "<p>Importing objects:</p>\n";

	foreach( $files as $filename ) {
		print "<li> Reading file $filename.. ";
		flush();
		$count = PluginImportObjects($filename);
		if( $count == 0 ) {
			print "no objects found?";
		} else if ($count == -1 ) {
			print "error reading file";
		} else {
			print "read $count.";
			$totalcount += $count;
		}
		print "<br>\n";
		flush();
	}

	print "<p>Read $totalcount objects in total</p>\n";
	exit();

} else if( $action == "importcfg" && count($files) > 0 ) {

	print "<p>Importing configuration files:</p>\n";

	foreach( $files as $fileid ) {
		$filename = NAGIOS_ETC.$NAGIOS_CFGFILES[$fileid];
		print "<li> Processing file : $filename.. ";
		flush();
		if( $result = PluginImportCfgFile($fileid) ) {
			print "failed : ".$result;
		} else {
			print "ok!";
			$totalcount++;
		}
		flush();
	}

	print "<p>Read $totalcount configuration files.</p>\n";
	exit();
}

?>
<p>
<form action="importer.php" method="POST">
<input type="hidden" name="action" value="importcfg">
</p>
<p>
No nagios.cfg data found. <br>
<br>
<?
	foreach($NAGIOS_CFGFILES as $key => $filename) {
		$fullloc = NAGIOS_ETC.$filename;
		print <<<HTML
<input type="checkbox" name="files[]" value="$key"> $fullloc<br>
HTML;
}

?>
<br>
<input type="submit" value="Start importing configuration files">
</p>
</form>

<?
if( $nagioscfg != NULL && is_array($nagioscfg['cfg_file']) ) {
?>
<p>
<form action="importer.php" method="POST">
<input type="hidden" name="action" value="importobjects">
</p>
<p>
Please select the files you want to import:<br>
</p>

<?
	foreach($nagioscfg['cfg_file'] as $filename) {
		print <<<HTML
<input type="checkbox" name="files[]" value="$filename"> $filename<br>
HTML;
}

?>
<br>
<input type="submit" value="Start importing objects">
</form>
<br>
<b><u>DevNote:</u></b> 
The importer will not clear the configuration currently loaded.<br>
You might end up with doubles when importing twice. This behaviour will
change<br> in the future.
<br>
<?
}

include_once(NGT_LIB."tail.inc");
?>
