/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_ip_callbacks_h
#define __nd_ip_callbacks_h

#include <netdude/nd_packet.h>
#include <netdude/nd_trace.h>
#include <netdude/nd_packet.h>

/* Button callbacks */

void   nd_ip_v_cb(ND_Packet   *packet,
		  guchar      *header,
		  guchar      *data);


void   nd_ip_hl_cb(ND_Packet   *packet,
		   guchar      *header,
		   guchar      *data);


void   nd_ip_ecn_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);


void   nd_ip_tos_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);


void   nd_ip_len_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);


void   nd_ip_id_cb(ND_Packet   *packet,
		   guchar      *header,
		   guchar      *data);


void   nd_ip_rf_cb(ND_Packet   *packet,
		   guchar      *header,
		   guchar      *data);


void   nd_ip_df_cb(ND_Packet   *packet,
		   guchar      *header,
		   guchar      *data);


void   nd_ip_mf_cb(ND_Packet   *packet,
		   guchar      *header,
		   guchar      *data);


void   nd_ip_off_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);


void   nd_ip_ttl_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);


void   nd_ip_p_cb(ND_Packet   *packet,
		  guchar      *header,
		  guchar      *data);


void   nd_ip_sum_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);


void   nd_ip_src_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);


void   nd_ip_dst_cb(ND_Packet   *packet,
		    guchar      *header,
		    guchar      *data);

/* IP Menu callbacks */

void   nd_ip_cksum_fix_cb(ND_Packet   *packet,
			  guchar      *header,
			  int          value);

void   nd_ip_fragment_cb(ND_Packet   *packet,
			 guchar      *header,
			 int          value);

void   nd_ip_reassemble_cb(ND_Packet   *packet,
			   guchar      *header,
			   int          value);

/* Option field callbacks */

void   nd_ip_opt_addr_cb(ND_Packet   *packet,
			 guchar      *header,
			 guchar      *data);


/* Menu item callbacks */

void   nd_ip_p_value_cb(ND_Packet   *packet,
			guchar      *header,
			int          value);


void   nd_ip_p_custom_cb(ND_Packet   *packet,
			 guchar      *header,
			 int          value);


void   nd_ip_ecn_value_cb(ND_Packet   *packet,
			  guchar      *header,
			  int          value);


void   nd_ip_tos_value_cb(ND_Packet   *packet,
			  guchar      *header,
			  int          value);


void   nd_ip_tos_custom_cb(ND_Packet   *packet,
			   guchar      *header,
			   int          value);

#endif
