
/*-------------------------------------------------------------*/
/* HMAC : RFC 2104
   This implementation only supports MD4 and MD5.
 */

/*-------------------------------------------------------------*/
#define NETWOX_HMACMD_HASH_LEN NETWOX_MD_HASH_LEN
#define NETWOX_HMACMD4_HASH_LEN NETWOX_MD4_HASH_LEN
#define NETWOX_HMACMD5_HASH_LEN NETWOX_MD5_HASH_LEN

/*-------------------------------------------------------------*/
typedef struct {
  /* md version */
  netwox_mdversion mdversion;
  /* precomputed keys */
#define NETWOX_HMACMD_B 64
  netwib_byte ki[NETWOX_HMACMD_B];
  netwib_byte ko[NETWOX_HMACMD_B];
} netwox_hmacmd_keys;

netwib_err netwox_hmacmd_keys_init(netwox_mdversion mdversion,
                                   netwib_constbuf *pkey,
                                   netwox_hmacmd_keys *pkeys);

/*-------------------------------------------------------------*/
netwib_err netwox_hmacmd_compute(netwox_hmacmd_keys *pkeys,
                                 netwib_constbuf *pbuf,
                                 netwib_buf *phmacmd);

/*-------------------------------------------------------------*/
netwib_err netwox_hmacmd_test(netwox_mdversion mdversion);
