
/*-------------------------------------------------------------*/
/* NETWOX_SMBCMD_TYPE_NTTRANSACT_Q */

/*-------------------------------------------------------------*/
typedef enum {
  NETWOX_SMBCMDTSCNTQ_TYPE_UNKNOWN = 0,
  NETWOX_SMBCMDTSCNTQ_TYPE_NTIOCTL,
  NETWOX_SMBCMDTSCNTQ_TYPE_NTNOTIFY,
  NETWOX_SMBCMDTSCNTQ_TYPE_NTQUERYSECUDESC,
  NETWOX_SMBCMDTSCNTQ_TYPE_NTSETSECUDESC
} netwox_smbcmdtscntq_type;

/*-------------------------------------------------------------*/
typedef struct {
  netwib_uint32 function; /* function to call 589864 or 590016 */
  netwib_uint16 fid;
  netwib_uint8 isfsctl; /* ?, always 1 */
  netwib_uint8 completionfilter; /* ?, always 0 */
} netwox_smbcmdtscntq_ntioctl;

/*-------------------------------------------------------------*/
typedef struct {
  netwib_uint32 completionfilter; /* event to watch for */
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_FILENAME       0x0001
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_DIRNAME        0x0002
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_ATTRIBUTE      0x0004
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_SIZE           0x0008
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_LASTWRITETIME  0x0010
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_LASTACCESSTIME 0x0020
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_CREATIONTIME   0x0040
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_EA             0x0080
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_SECU           0x0100
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_STREAMNAME     0x0200
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_STREAMSIZE     0x0400
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_COMPLETIONFILTER_STREAMWRITE    0x0800
  netwib_uint16 fid;
  netwib_uint16 watchtree; /* if also watch in subdirectories */
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_WATCHTREE_CURDIRONLY 0
#define NETWOX_SMBCMDTSCNTQ_NTNOTIFY_WATCHTREE_ALSOSUBDIR 1
} netwox_smbcmdtscntq_ntnotify;

/*-------------------------------------------------------------*/
typedef struct {
  netwib_uint16 fid;
  netwib_uint32 secinfo; /* requested info */
#define NETWOX_SMBCMDTSCNTQ_SECUDESC_SECINFO_OWNER 0x01
#define NETWOX_SMBCMDTSCNTQ_SECUDESC_SECINFO_GROUP 0x02
#define NETWOX_SMBCMDTSCNTQ_SECUDESC_SECINFO_DACL  0x04
#define NETWOX_SMBCMDTSCNTQ_SECUDESC_SECINFO_SACL  0x08
} netwox_smbcmdtscntq_ntquerysecudesc;

/*-------------------------------------------------------------*/
typedef struct {
  netwib_uint16 fid;
  netwib_uint32 secinfo; /* set info */
  netwox_smbcmdcmn_data secudesc; /* too complex to decode for now */
} netwox_smbcmdtscntq_ntsetsecudesc;

/*-------------------------------------------------------------*/
typedef struct {
  netwox_smbcmdtscntq_type type;
  union {
    netwox_smbcmdtscntq_ntioctl ntioctl;
    netwox_smbcmdtscntq_ntnotify ntnotify;
    netwox_smbcmdtscntq_ntquerysecudesc ntquerysecudesc;
    netwox_smbcmdtscntq_ntsetsecudesc ntsetsecudesc;
  } value;
} netwox_smbcmdtscntq;
typedef const netwox_smbcmdtscntq netwox_constsmbcmdtscntq;

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtscntq_init(netwox_smbcmdtscntq *psmbcmdtscntq);
netwib_err netwox_smbcmdtscntq_selecttype(netwox_smbcmdtscntq *psmbcmdtscntq,
                                         netwox_smbcmdtscntq_type type);
netwib_err netwox_smbcmdtscntq_setdefault(netwox_smbcmdtscntq *psmbcmdtscntq);
netwib_err netwox_smbcmdtscntq_close(netwox_smbcmdtscntq *psmbcmdtscntq);

/*-------------------------------------------------------------*/
/* for those 2 functions :
    - don't forget to set isunicode before
    - they suppose query is stored only in first message (most
      of the time, query is small, so this is ok)
*/
netwib_err netwox_smbcmdtscntq_encode_smbcmd(netwox_constsmbcmd *psmbcmd,
                                          netwox_smbcmdtscntq *psmbcmdtscntq);
/* only decode setup/para/data. Other values have to be set by user */
netwib_err netwox_smbcmdtscntq_decode_smbcmd(netwox_constsmbcmdtscntq *psmbcmdtscntq,
                                             netwox_smbcmd *psmbcmd);

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtscntq_show(netwox_constsmbcmdtscntq *psmbcmdtscntq,
                                   netwib_buf *pbuf);
