/*
**  IMAPStore.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_IMAPStore
#define _Pantomime_H_IMAPStore

#include <Pantomime/Service.h>
#include <Pantomime/Store.h>

#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

@class Connection;
@class Flags;
@class IMAPCacheManager;
@class IMAPFolder;
@class IMAPMessage;
@class TCPConnection;

@interface IMAPStore : NSObject <Service, Store>
{
  NSMutableDictionary *folders, *openedFolders, *folderStatus;
  NSString *name, *folderSeparator, *username;
  NSMutableArray *subscribedFolders, *capabilities;
 
  id<Connection> tcpConnection;  
  id delegate;

  int port, tag;
  
  @public
    struct {
      NSMutableArray *searchResponse;
      NSString       *lastCommand;
      NSString       *lastResponse;
      BOOL           lastCommandWasSuccessful;
      BOOL           messagesWereReceived;
      BOOL           messagesWereExpunged;
      BOOL           messagesFlagsHaveChanged;
      BOOL           connected;
    } _status;
}

- (IMAPFolder *) folderForName: (NSString *) theName
                          mode: (int) theMode
                      prefetch: (BOOL) aBOOL;

- (IMAPFolder *) folderForName: (NSString *) theName
                        select: (BOOL) aBOOL;

- (NSString *) nextTag;
- (NSString *) lastTag;

- (BOOL) subscribeToFolderWithName: (NSString *) theName;
- (BOOL) unsubscribeToFolderWithName: (NSString *) theName;

- (void) noop;

- (id) delegate;
- (void) setDelegate: (id) theDelegate;

//
// Other methods
//
- (NSDictionary *) folderStatus: (NSArray *) theArray;

- (NSArray *) capabilities;

@end


//
// Private methods
//
@interface IMAPStore (Private)

- (BOOL) _cramMD5Authentication: (NSString *) theUsername
                       password: (NSString *) thePassword;

- (NSString *) _folderNameFromString: (NSString *) theString;
- (NSString *) _lastCommand;

- (BOOL) _loginAuthentication: (NSString *) theUsername
                     password: (NSString *) thePassword;

- (void) _messagesWereReceived;
- (void) _parseCapability: (NSString *) theString;
- (void) _parseExists: (NSString *) theString;
- (void) _parseExpunge: (NSString *) theString;
- (void) _parseFetch: (NSString *) theString
                 msn: (int) theMSN;
- (void) _parseFlags: (NSString *) aString
             message: (IMAPMessage *) theMessage;
- (void) _parseList: (NSString *) theString;
- (void) _parseSearch: (NSString *) theString;
- (void) _parseServerOutput;
- (void) _parseStatus: (NSString *) theString;
- (void) _parseUIDValidity: (NSString *) theString;
- (void) _preInit;
- (int) _segmentSizeFromWord: (NSString *) theWord;
- (void) _sendCommand: (NSString *) theCommand;

@end

#endif // _Pantomime_H_IMAPStore
