--TEST--
maxdb bind_param/bind_result date
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);
		
        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE bind_result");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_result(c1 date, c2 time, 
                                                        c3 timestamp, 
                                                        c4 timestamp, 
                                                        c5 timestamp)");

	$stmt = maxdb_prepare($link, "INSERT INTO test_bind_result VALUES (?,?,?,?,?)");
	maxdb_bind_param($stmt, "sssss", $d1, $d2, $d3, $d4, $d5);

  	$d1 = '2002-01-02';
	$d2 = '12:49:00';
	$d3 = '2002-01-02 17:46:59';
	$d4 = '2003-07-12 22:30:45';
	$d5 = '2004-04-19 10:46:59';

	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_result");

  	maxdb_bind_result($stmt,$c1, $c2, $c3, $c4, $c5);
	
 	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($c1,$c2,$c3,$c4,$c5);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(5) {
  [0]=>
  string(10) "2002-01-02"
  [1]=>
  string(8) "12:49:00"
  [2]=>
  string(26) "2002-01-02 17:46:59.000000"
  [3]=>
  string(26) "2003-07-12 22:30:45.000000"
  [4]=>
  string(26) "2004-04-19 10:46:59.000000"
}
