<?php
	/***************************************************************************\
	* phpGroupWare - Notes                                                      *
	* http://www.phpgroupware.org                                               *
	* Written by : Bettina Gille [ceb@phpgroupware.org]                         *
	*              Andy Holman (LoCdOg)                                         *
	* -------------------------------------------------                         *
	* Copyright 2000 - 2003 Free Software Foundation, Inc               		*
	*                                                                           *
	* This program is free software; you can redistribute it and/or modify it   *
	* under the terms of the GNU General Public License as published by the     *
	* Free Software Foundation; either version 2 of the License, or (at your    *
	* option) any later version.                                                *
	\***************************************************************************/
	/* $Id: class.uinotes.inc.php,v 1.29.2.1 2003/11/04 15:06:39 ceb Exp $ */

	class uinotes
	{
		var $grants;
		var $cat_id;
		var $start;
		var $search;
		var $filter;
		var $bo;
		var $cats;
		var $nextmatchs;
		var $t;

		var $public_functions = array
		(
			'_list'  => True,
			'view'   => True,
			'add'    => True,
			'edit'   => True,
			'delete' => True,
			'preferences' => True
		);

		function uinotes()
		{
			$this->cats       = CreateObject('phpgwapi.categories');
			$this->nextmatchs = CreateObject('phpgwapi.nextmatchs');
			$this->account    = $GLOBALS['phpgw_info']['user']['account_id'];
			$this->t          = $GLOBALS['phpgw']->template;
			$this->grants     = $GLOBALS['phpgw']->acl->get_grants('notes');
			$this->grants[$this->account] = PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;
			$this->bo         = CreateObject('notes.bonotes',True);

			$this->start  = $this->bo->start;
			$this->search = $this->bo->search;
			$this->filter = $this->bo->filter;
			$this->cat_id = $this->bo->cat_id;
		}

		function save_sessiondata()
		{
			$data = array
			(
				'start'  => $this->start,
				'search' => $this->search,
				'filter' => $this->filter,
				'cat_id' => $this->cat_id
			);
			$this->bo->save_sessiondata($data);
		}

		function set_app_langs()
		{
			$this->t->set_var('bg_color',$GLOBALS['phpgw_info']['theme']['th_bg']);
			$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
			$this->t->set_var('tr_color',$tr_color);
			$this->t->set_var('font',$this->bo->set_font());
			$this->t->set_var('font_size',$this->bo->set_font_size());
			$this->t->set_var('name',$GLOBALS['phpgw_info']['user']['fullname']);

			$this->t->set_var('lang_categories',lang('Categories'));
			$this->t->set_var('lang_category',lang('Category'));
			$this->t->set_var('lang_notes',lang('Notes'));
			$this->t->set_var('lang_search',lang('Search'));
			$this->t->set_var('lang_submit',lang('Submit'));
			$this->t->set_var('lang_all',lang('All'));
			$this->t->set_var('lang_view',lang('View'));
			$this->t->set_var('lang_choose',lang('Choose the category'));
			$this->t->set_var('lang_access',lang('Private'));
			$this->t->set_var('lang_done',lang('Done'));
			$this->t->set_var('lang_save',lang('Save'));
			$this->t->set_var('done_action',$GLOBALS['phpgw']->link('/index.php','menuaction=notes.uinotes._list'));
		}

		function display_app_header()
		{
			$this->t->set_file(array('header' => 'header.tpl'));
            $this->t->set_block('header','notes_header');

			$this->set_app_langs();

			$this->t->set_var('link_categories',$GLOBALS['phpgw']->link('/index.php','menuaction=preferences.uicategories.index&cats_app=notes&cats_level=True&global_cats=True'));
			$this->t->set_var('link_notes',$GLOBALS['phpgw']->link('/notes/index.php','menuaction=notes.uinotes._list'));
			$this->t->fp('app_header','notes_header');

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();
		}

		function _list()
		{
			$this->display_app_header();

			$this->t->set_file(array('notes_list_t' => 'list.tpl'));
			$this->t->set_block('notes_list_t','notes_list','list');

			if (!$this->start)
			{
				$this->start = 0;
			}

			$notes_list = $this->bo->_list($this->start,$this->search,$this->filter,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$link_data = array
			(
				'menuaction' => 'notes.uinotes._list'
			);

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bo->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bo->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('search_message',$this->nextmatchs->show_hits($this->bo->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php',$link_data));
			$this->t->set_var('title_notes',lang('Personalized notes for'));
			$this->t->set_var('cat_action',$GLOBALS['phpgw']->link('/index.php',$link_data));
			$this->t->set_var('filter_action',$GLOBALS['phpgw']->link('/index.php',$link_data));
			$this->t->set_var('category_list',$this->cats->formated_list('select','all',$this->cat_id,True));

			switch($this->filter)
			{
				case 'all': $filter_sel[0]=' selected';break;
				case 'public': $filter_sel[1]=' selected';break;
				case 'private': $filter_sel[2]=' selected';break;
			}

			$filter_list = '<option value="all"' . $filter_sel[0] . '>' . lang('Show all') . '</option>' . "\n"
				. '<option value="public"' . $filter_sel[1] . '>' . lang('Only yours') . '</option>' . "\n"
				. '<option value="private"' . $filter_sel[2] . '>' . lang('Private') . '</option>' . "\n";

			$this->t->set_var('filter_list',$filter_list);

			for ($i=0;$i<count($notes_list);$i++)
			{
				$note_owner = intval($notes_list[$i]['owner_id']);
				$new_dateout = $notes_list[$i]['date'];

				$words = split(' ',$GLOBALS['phpgw']->strip_html($notes_list[$i]['content']));
				$first = "$words[0] $words[1] $words[2] $words[3] .....";
				$this->nextmatchs->template_alternate_row_color(&$this->t);

				$this->t->set_var(array
				(
					'new_date' => $new_dateout,
					'first' => $first
				));

				$link_data['note_id']		= $notes_list[$i]['id'];
				$link_data['menuaction']	= 'notes.uinotes.view';

				$this->t->set_var('view',$GLOBALS['phpgw']->link('/index.php',$link_data));

				if ($this->bo->check_perms($this->grants[$note_owner],PHPGW_ACL_EDIT) || $note_owner == $this->account)
				{
					$link_data['menuaction'] = 'notes.uinotes.edit';
					$this->t->set_var('edit',$GLOBALS['phpgw']->link('/index.php',$link_data));
					$this->t->set_var('lang_edit',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit','');
				}

				if ($this->bo->check_perms($this->grants[$note_owner],PHPGW_ACL_DELETE) || $note_owner == $this->account)
				{
					$link_data['menuaction'] = 'notes.uinotes.delete';
					$this->t->set_var('delete',$GLOBALS['phpgw']->link('/index.php',$link_data));
					$this->t->set_var('lang_delete',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete','');
				}

				$this->t->fp('list','notes_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction']	= 'notes.uinotes.add';
			$link_data['cat_id']		= $this->cat_id;

			if ($cat[0]['app_name'] == 'phpgw' || $cat[0]['owner'] == '-1' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $GLOBALS['phpgw']->link('/index.php',$link_data)
					. '"><input type="submit" name="Add" value="' . lang('Add note') .'"></font></form>');
			}
			else
			{
				if ($this->bo->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $GLOBALS['phpgw']->link('/index.php',$link_data)
						. '"><input type="submit" name="Add" value="' . lang('Add note') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->pfp('out','notes_list_t');
			$this->save_sessiondata();
		}

		function add()
		{
			$cat_id		= get_var('cat_id',array('POST','GET'));
			$new_cat	= get_var('new_cat',array('POST'));
			$addnote	= get_var('addnote',array('POST'));
			$note		= get_var('note',array('POST'));

		/*	if ($GLOBALS['spellcheck'])
			{
				$check_fields = array(
					'content' => $GLOBALS['note']['content']
				);

				$spellcheck = createobject('phpgwapi.spellcheck');
				$spellcheck->check('notes.uinotes.add',$check_fields,array());

				return False;
			} */

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			if ($addnote)
			{
				$note['category'] = $cat_id;

				$this->bo->save($note);
//				$this->t->set_var('message',lang('Note has been added for %1 !',$GLOBALS['phpgw_info']['user']['fullname']));
				$this->cat_id = $cat_id;
				$this->_list();
				return False;
			}
			else
			{
				$this->display_app_header();

				$this->t->set_file(array('form' => 'form.tpl'));
				$this->t->set_block('form','add','addhandle');
				$this->t->set_block('form','edit','edithandle');

				$this->t->set_var('message','');
				$this->t->set_var('lang_action',lang('Add a note for'));
				$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=notes.uinotes.add&cat_id=' . $cat_id));
				$this->t->set_var('content',$note['content']);
				$this->t->set_var('main_cat_list',$this->cats->formated_list('select','all',$cat_id,'True'));

				$this->t->set_var('access','<input type="checkbox" name="note[access]" value="True" checked>');

				$this->t->set_var('lang_reset',lang('Clear Form'));
				$this->t->set_var('lang_add',lang('Add note'));
				$this->t->set_var('edithandle','');
				$this->t->set_var('addhandle','');
				$this->t->pfp('out','form');
				$this->t->pfp('addhandle','add');
			}
		}

		function edit()
		{
			$note_id	= get_var('note_id',array('GET','POST'));
			$cat_id		= get_var('cat_id',array('GET','POST'));
			$new_cat	= get_var('new_cat',array('POST'));
			$editnote	= get_var('editnote',array('POST'));
			$note		= get_var('note',array('POST'));

			$this->display_app_header();

			$this->t->set_file(array('form' => 'form.tpl'));
			$this->t->set_block('form','add','addhandle');
			$this->t->set_block('form','edit','edithandle');

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			if ($editnote)
			{
				$note['category'] = $cat_id;
				$note['id'] = $note_id;

				$this->bo->save($note);
				$this->t->set_var('message',lang('Note has been updated for %1 !',$GLOBALS['phpgw_info']['user']['fullname']));
			}
			else
			{
				$this->t->set_var('message','');
			}

			$note = $this->bo->read($note_id);

			$this->t->set_var('lang_action',lang('Edit note for'));
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=notes.uinotes.edit&cat_id=' . $cat_id . '&note_id=' . $note_id));
			$this->t->set_var('content',$GLOBALS['phpgw']->strip_html($note['content']));
			$this->t->set_var('main_cat_list',$this->cats->formated_list('select','all',$note['category'],'True'));
			$this->t->set_var('lang_edit',lang('Edit'));

			$this->t->set_var('access','<input type="checkbox" name="note[access]" value="True"' . ($note['access'] == 'private'?' checked':'') . '>');

			if ($this->bo->check_perms($this->grants[$note['owner']],PHPGW_ACL_DELETE) || $note['owner'] == $this->account)
			{
				$this->t->set_var('delete','<form method="POST" action="' . $GLOBALS['phpgw']->link('/index.php','menuaction=notes.uinotes.delete&note_id=' . $note_id)
					. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','form');
			$this->t->pfp('edithandle','edit');
		}

		function delete()
		{
			$note_id	= get_var('note_id',array('GET','POST'));

			if ($_POST['confirm'])
			{
				$this->bo->delete($note_id);
				$GLOBALS['phpgw']->redirect_link('/index.php','menuaction=notes.uinotes._list');
			}
			else
			{
				$this->display_app_header();

				$this->t->set_file('delete','delete.tpl');

				$this->t->set_var('action_url',$GLOBALS['phpgw']->link('/index.php','menuaction=notes.uinotes.delete&note_id=' . $note_id));
				$this->t->set_var('done_action',$GLOBALS['phpgw']->link('/index.php','menuaction=notes.uinotes._list'));
				$this->t->set_var('deleteheader',lang('Are you sure you want to delete this note ?'));
				$this->t->set_var('lang_no',lang('No'));
				$this->t->set_var('lang_yes',lang('Yes'));
				$this->t->pfp('out','delete');
			}
		}

		function view()
		{
			$note_id = get_var('note_id',array('GET'));

			$this->display_app_header();

			$this->t->set_file('view','view.tpl');

			$this->t->set_var('lang_time',lang('Time created'));
			$this->t->set_var('lang_action',lang('Display note for'));
			$this->t->set_var('lang_access',lang('Access'));

			$note = $this->bo->read($note_id);

			$this->t->set_var('category',$this->cats->id2name($note['category']));
			$this->t->set_var('new_date',$GLOBALS['phpgw']->common->show_date($note['date']));
			$this->t->set_var('fnote',nl2br($GLOBALS['phpgw']->strip_html($note['content'])));
			$this->t->set_var('access',ucfirst($note['access']));

			$this->t->pfp('out','view');
		}

		function preferences()
		{
			$submit	= get_var('submit',array('POST'));
			$prefs	= get_var('prefs',array('POST'));

			if ($submit)
			{
				$this->bo->save_preferences($prefs);
				Header('Location: ' . $GLOBALS['phpgw']->link('/preferences/index.php'));
				$GLOBALS['phpgw']->common->phpgw_exit();
			}

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->t->set_file(array('preferences' => 'preferences.tpl'));
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=notes.uinotes.preferences'));

			$this->set_app_langs();

			$this->t->set_var('lang_action',lang('Notes preferences'));
			$this->t->set_var('lang_select_font',lang('Choose a font'));
			$this->t->set_var('lang_select_size',lang('Choose the font size'));

			$prefs = $this->bo->read_preferences();

			switch($prefs['notes_font'])
			{
				case'Arial,Helvetica,sans-serif': $font_sel[0]=' selected'; break;
				case'Times New Roman,Times,serif': $font_sel[1]=' selected'; break;
				case'Verdana,Arial,Helvetica,sans-serif': $font_sel[2]=' selected'; break; 
				case'Georgia,Times New Roman,Times,serif': $font_sel[3]=' selected'; break;
				case'Courier New,Courier,mono': $font_sel[4]=' selected'; break;
				case'Helvetica,Arial,sans-serif': $font_sel[5]=' selected'; break; 
				case'Tahoma,Verdana,Arial,Helvetica,sans-serif': $font_sel[6]=' selected'; break;
			}

			$notes_font = '<option value="Arial,Helvetica,sans-serif"' . $font_sel[0] . '>' . lang('Arial') . '</option>' . "\n"
				. '<option value="Times New Roman,Times,serif"' . $font_sel[1] . '>' . lang('Times New Roman') . '</option>' . "\n"
				. '<option value="Verdana,Arial,Helvetica,sans-serif"' . $font_sel[2] . '>' . lang('Verdana') . '</option>' . "\n"
				. '<option value="Georgia,Times New Roman,Times,serif"' . $font_sel[3] . '>' . lang('Georgia') . '</option>' . "\n"
				. '<option value="Courier New,Courier,mono"' . $font_sel[4] . '>' . lang('Courier New') . '</option>' . "\n"
				. '<option value="Helvetica,Arial,sans-serif"' . $font_sel[5] . '>' . lang('Helvetica') . '</option>' . "\n"
				. '<option value="Tahoma,Verdana,Arial,Helvetica,sans-serif"' . $font_sel[6] . '>' . lang('Tahoma') . '</option>' . "\n";

			$this->t->set_var('notes_font',$notes_font);

			switch($prefs['notes_font_size'])
			{
				case 1: $size_sel[0]=' selected'; break;
				case 2: $size_sel[1]=' selected'; break;
				case 3: $size_sel[2]=' selected'; break;
				case 4: $size_sel[3]=' selected'; break;
				case 5: $size_sel[4]=' selected'; break;
			}

			$notes_font_size = '<option value="1"' . $size_sel[0] . '>' . lang('Very Small') . '</option>' . "\n"
				. '<option value="2"' . $size_sel[1] . '>' . lang('Small') . '</option>' . "\n"
				. '<option value="3"' . $size_sel[2] . '>' . lang('Medium') . '</option>' . "\n"
				. '<option value="4"' . $size_sel[3] . '>' . lang('Large') . '</option>' . "\n"
				. '<option value="5"' . $size_sel[4] . '>' . lang('Very Large') . '</option>' . "\n";

			$this->t->set_var('notes_font_size',$notes_font_size);

			$this->t->pfp('out','preferences');
		}
	}
?>
