# user.pm
# Helper functions for the user to call from Perl expressions parsed by the
# Perl PreProcessor
#
# Part of the
# Perl Instaler and Configuration Agent (PICA)
# or
# PICA Is for C{ompetent,ompulsive,razy} Admins
#
#   Copyright (C) 2001,2002  Miguel Armas, Esteban Manchado
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package user;
require Exporter;
use Data::Dumper;
use vars qw(@ISA @EXPORT @EXPORT_OK);
@ISA = qw (Exporter);

@EXPORT = qw(ingroup members membersindomain);
@EXPORT_OK = qw(ingroup members membersindomain);

# Aliases to global variables (ouch!)
no strict;
*hostref = *main::hostref;
*picahost = *main::picahost;
*hostvars = *main::hostvars;

# FUNCTION: ingroup($group)
# DESCRIPTION: check if $picahost belongs to the given group
sub ingroup {
   my $groupname = shift;

   if ((exists $hostref->{$groupname}{'members'}) &&
       (grep(/^$picahost$/,@{$hostref->{$groupname}{'members'}}))) {
	  return 1;
   }
   else {
      return 0;
   }
}

# FUNCTION: members($group,"joinstring")
# DESCRIPTION: returns the members of the given group. If a second argument 
# is specified, it returns a string containing the members and joined with 
# the given string 
sub members {
   my $groupname = shift;
   my $joinstr = shift;

   if (exists $hostref->{$groupname}{'members'}) {
      if ($joinstr) {
         return join($joinstr,@{$hostref->{$groupname}{'members'}})
      }
      else {
         return @{$hostref->{$groupname}{'members'}};
      }
   }
   else {
      return "";
   }
}

# FUNCTION: membersindomain($group)
# DESCRIPTION: returns the members of the given group that belong to the
# same admindomain as the host being processed
sub membersindomain {
   my $groupname = shift;
   my $admindomain = $hostvars{'admindomain'};

   if (exists $hostref->{$groupname}{'members'}) {
      if (exists $hostref->{$admindomain}{'members'}) {
            return intersection($hostref->{$groupname}{'members'},
	                        $hostref->{$admindomain}{'members'});
      }
      else {
            return ();
      }
   }
   else {
      return ();
   }
}

# FUNCTION: intersection(\@array1,\@array2)
# DESCRIPTION: returns the intersection of two arrays
sub intersection {
    my $rArray1 = shift;
    my $rArray2 = shift;
    my @union = @intersection = @difference = ();
    my %count = ();
    foreach $element (@{$rArray1}, @{$rArray2}) { $count{$element}++ }
    foreach $element (keys %count) {
       push @union, $element;
       push @{ $count{$element} > 1 ? \@intersection : \@difference }, $element;
    }
    return @intersection
}

1;
