//
//  PRWindowController.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2002-2003 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRWindowController.h"
#import "MyDocument.h"


@implementation PRWindowController

- (void)scaleImageTo:(float)_scale
{
    if (_scale > 0)
        scale = _scale;
    [view scaleFrameBy:scale];
    
    /* now we update the controls */
    [zoomControl setFloatValue:(scale * 100)];
    if (scale * 100 > [zoomSlider maxValue])
        [zoomSlider setFloatValue:[zoomSlider maxValue]];
    else if (scale * 100 < [zoomSlider minValue])
        [zoomSlider setFloatValue:[zoomSlider minValue]];
    else
        [zoomSlider setFloatValue:(scale * 100)];
}

- (IBAction)changeScale:(id)sender
{
    [self scaleImageTo:([sender floatValue] / 100.0)];
}

- (void)windowDidLoad
/* some initialization stuff */
{
    /* display the data by MyDocument's activeImage method */
    NSImage *image = [[self document] activeImage];
    
    [view setImage:image];
    [self scaleImageTo:1.0];
}

- (NSView *)view
/* view accessor */
{
    return view;
}
- (void)setImageToDraw:(NSImage *)image
{
    [view setImage:image];
}

-(void) dealloc
{
    [super dealloc];
}

@end
