/* Header for module plot_routines, generated by p2c */
#ifndef PLOT_ROUTINES_H
#define PLOT_ROUTINES_H



#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef PLOT_H
#include <p2c/plot.h>
#endif

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif



#ifdef PLOT_ROUTINES_G
# define vextern
#else
# define vextern extern
#endif



#define mam_x           1
#define mam_y           2
#define mam_y2          3

#define mam_defcharsize 0.018

/*1/55*/
#define mam_deftitlesize 0.025

/*1/40*/
#define mam_defsymbolxoff (-0.3125)

/*optimized for "*" in font 2*/
#define mam_defsymbolyoff (-0.69)



/*For internal use, or for use with mam_new*/
/*For lazy users to pass in*/
/*Initialization & exit*/

typedef double mam_longvectorarray[1000000L];

typedef double mam_vectorarray[3000];



extern Void mam_init_plotter PV( );
extern Void mam_init_screen PV( );
extern Void mam_init_file PP((Char *fname));
extern Void mam_init_ps PP((Char *fname));

/*obsolete*/
extern Void mam_init_generic PV( );
extern Void mam_setup_generic PV( );
extern Void mam_quality PV( );
extern Void mam_close PV( );
extern Void mam_close_generic PV( );

/*Allocate a variable-sized vector*/
extern Void mam_new PP((double **vec, long size));
extern Void mam_dispose PP((double **vec, long size));

/*Scaling the data*/
extern double mam_log PP((double x));

/*see also log(x) in MATH module*/
extern Void mam_scale PP((double **x, double **y, long len));
extern Void mam_scalenormal PP((double **x, double **y, long len,
				double **normalx));
extern Void mam_rscale PP((double **x, double **y, long len));
extern Void mam_scale_generic PP((long axis, double **x, long len));
extern Void mam_range PP((long axis, double min, double max));
extern Void mam_fullrange PP((long axis, double min, double max,
			      double interval));
extern Void mam_getrange PP((long axis, double *min, double *max,
			     double *interval));
extern Void mam_intlabel PP((long axis));

/*integers only*/
extern Void mam_englabel PP((long axis));

/*engineering notation*/
extern Void mam_fltlabel PP((long axis));

/*floating notation*/
extern Void mam_fixlabel PP((long axis));

/*decimal notation*/
extern Void mam_gridaxis PP((long axis));
extern Void mam_grid PV( );
extern Void mam_mirroraxis PP((long axis));

/*Setting & drawing the axes*/
extern Void mam_axis PP((Char *xtitle, Char *xunits, Char *xplottype,
			 Char *ytitle, Char *yunits, Char *yplottype));
extern Void mam_axis3 PP((Char *xtitle, Char *xunits, Char *xplottype,
			  Char *y1title, Char *y1units, Char *y1plottype,
			  Char *y2title, Char *y2units, Char *y2plottype));
extern Void mam_drawborder PV( );
extern Void mam_drawaxes PV( );

/*Low-level graphics*/
extern Void mam_move PP((double xto, double yto, long yaxis));

/*These names are BAD to export!*/
extern Void mam_draw PP((double xto, double yto, long yaxis));

/* -- DAVE 11/10/87*/
extern Void mam_move_ PP((double xto, double yto, long yaxis));
extern Void mam_draw_ PP((double xto, double yto, long yaxis));
extern Void mam_transform PP((double x, double y, long yaxis, double *tx,
			      double *ty));
extern Void mam_rtransform PP((double dx, double dy, long yaxis, double *tdx,
			       double *tdy));
extern Void mam_untransform PP((double tx, double ty, long yaxis, double *x,
				double *y));
extern Void mam_runtransform PP((double tdx, double tdy, long yaxis,
				 double *dx, double *dy));

/*Plotting the data*/
extern Void mam_plot PP((double **x, double **y, long len));
extern Void mam_plotnormal PP((double **x, double **y, long len,
			       double **normalx));
extern Void mam_plot3 PP((double **x, double **y, long len));
extern Void mam_splot PP((double **x, double **y, long len, int symbol));
extern Void mam_splot3 PP((double **x, double **y, long len, int symbol));

/*Plotting other stuff*/
extern Void mam_title PP((Char *s));
extern Void mam_date PV( );
extern Void mam_plotstring PP((Char *s, double x, double y));

/* MAS 11/4/86 */
extern Void mam_tex PV( );

/*Setting up internal parameters*/
extern Void mam_charsize PP((double frac));

/*size of all characters*/
extern Void mam_font PP((long num));

/*font for everything*/
extern Void mam_color PP((long col));

/*color for everything*/
extern Void mam_axissize PP((double frac));

/*set size of axis names only*/
extern Void mam_axisfont PP((long num));
extern Void mam_axiscolor PP((long col));
extern Void mam_labelsize PP((double frac));

/*set size of axis values only*/
extern Void mam_labelfont PP((long num));
extern Void mam_labelcolor PP((long col));
extern Void mam_titlesize PP((double frac));

/*set size of title string only*/
extern Void mam_titlefont PP((long num));
extern Void mam_titlecolor PP((long col));
extern Void mam_symbolsize PP((double frac));

/*set size of symbol character only*/
extern Void mam_symbolfont PP((long num));
extern Void mam_symbolcolor PP((long col));
extern Void mam_symboloffset PP((double xfrac, double yfrac));
extern Void mam_setfontfile PP((Char *fn));
extern Void mam_ticksize PP((double frac));

/*size of tick marks*/
extern Void mam_tickcolor PP((long col));
extern Void mam_bordercolor PP((long col));
extern Void mam_datacolor PP((long col));
extern Void mam_datastyle PP((long style));
extern Void mam_drawlabel PP((double x, double y, Char *lbl));

/* *** some random data analysis stuff, added by Mass *** */
extern double mam_mean PP((double **x, long len));
extern double mam_stddev PP((double **x, long len));
extern double mam_normal PP((double mean, double stddev, double x));
extern Void mam_lower_title PP((Char *s));



vextern long lowerfudge;



#undef vextern

#endif /*PLOT_ROUTINES_H*/

/* End. */

