from Ft.Ods import Enumeration

TYPEID=-102

class CollectionKindElement(Enumeration.EnumElement):
    nameMapping={0:'ck_list',
                 1:'ck_array',
                 2:'ck_bag',
                 3:'ck_set',
                 4:'ck_dictionary',
                 5:'ck_sequence',
                 6:'ck_string',
                 }
    def __init__(self,db,value):
        if value == None: value = 0
        if type(value) == type(()):
            value = value[0]
        Enumeration.EnumElement.__init__(self,db,self.nameMapping[value],value,'CollectionKind',TYPEID)



ck_list = CollectionKindElement(None,0)
ck_array = CollectionKindElement(None,1)
ck_bag = CollectionKindElement(None,2)
ck_set = CollectionKindElement(None,3)
ck_dictionary = CollectionKindElement(None,4)
ck_sequence = CollectionKindElement(None,5)
ck_string = CollectionKindElement(None,6)

class CollectionKindEnum(Enumeration.Enumeration):
    def __init__(self):
        Enumeration.Enumeration.__init__(self,
                                         "CollectionKind",
                                         TYPEID,
                                         [ck_list,
                                          ck_array,
                                          ck_bag,
                                          ck_set,
                                          ck_dictionary,
                                          ck_sequence,
                                          ck_string,
                                          ])


CollectionKind = CollectionKindEnum()
