import XmlDocumentClient

class ServerClient(XmlDocumentClient.XmlDocumentClient):
    """
    A system server
    """

    def getStatus(self):
        """
        Returns the state of this server: running (1) or stopped (0)
        based on the content of the resource. No check is made to see
        if a server process is running.
        """
        return Commands.RemoteMethodCommand('getStatus',
                                            self._path,
                                            (),
                                            ).send(self._connection).results

    def setRunning(self):
        """
        Change the state of this server to running
        """
        raise NotImplementedError("setRunning")


    def setStopped(self):
        """
        Change the state of this server to stopped
        """
        raise NotImplementedError("setStopped")


