
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Literal
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_operand
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)

    try:
    
        test_operand.Test(tester,db,Literal.Literal)


        tester.startGroup("Literal Interface %s Driver" % tester.test_data['driver'])

        test_metadata_util.test_primitive_type(tester,db,Literal.Literal,'literal_value',1)

        tester.startTest("value function")

        tx = db.new()
        tx.begin()

        l = Literal.Literal(db,None)
        l.literal_value = 1
        tester.compare(1, l.value(), "value function")

        tx.abort()

        tester.testDone()



        tester.groupDone()
    finally:
        db.close()

