import string, httplib, mimetools, base64
from Ft.Xml import XPath
from Ft.Xml import cDomlette

from Ft.Server.Protocols.Http import CommonHandler, SoapHandler


reader = cDomlette.RawExpatReader()

xmlText = """<?xml version = "1.0"?>
<ADDRBOOK>
    <ENTRY ID="pa">
        <NAME>Pieter Aaron</NAME>
        <ADDRESS>404 Error Way</ADDRESS>
        <PHONENUM DESC="Work">404-555-1234</PHONENUM>
        <PHONENUM DESC="Fax">404-555-4321</PHONENUM>
        <PHONENUM DESC="Pager">404-555-5555</PHONENUM>
        <EMAIL>pieter.aaron@inter.net</EMAIL>
    </ENTRY>
    <ENTRY ID="en">
        <NAME>Emeka Ndubuisi</NAME>
        <ADDRESS>42 Spam Blvd</ADDRESS>
        <PHONENUM DESC="Work">767-555-7676</PHONENUM>
        <PHONENUM DESC="Fax">767-555-7642</PHONENUM>
        <PHONENUM DESC="Pager">800-SKY-PAGEx767676</PHONENUM>
        <EMAIL>endubuisi@spamtron.com</EMAIL>
    </ENTRY>
    <ENTRY ID="vz">
        <NAME>Vasia Zhugenev</NAME>
        <ADDRESS>2000 Disaster Plaza</ADDRESS>
        <PHONENUM DESC="Work">000-987-6543</PHONENUM>
        <PHONENUM DESC="Cell">000-000-0000</PHONENUM>
        <EMAIL>vxz@magog.ru</EMAIL>
    </ENTRY>
</ADDRBOOK>
"""

fetchContainerReq1 = """
<SOAP-ENV:Envelope
  xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
  SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
>
  <SOAP-ENV:Body>
    <ft:Fetch xmlns:ft="http://xmlns.4suite.org/services" path='/soap/test.com'/>
  </SOAP-ENV:Body>
</SOAP-ENV:Envelope>"""



createTestContainer = """
<SOAP-ENV:Envelope
  xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
  SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
>
  <SOAP-ENV:Body>
    <ft:Create xmlns:ft="http://xmlns.4suite.org/services">
      <ft:Container path='/soap/test.com' create-parents='1'/>
    </ft:Create>
  </SOAP-ENV:Body>
</SOAP-ENV:Envelope>"""

deleteTestContainer = """
<SOAP-ENV:Envelope
  xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
  SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
>
  <SOAP-ENV:Body>
    <ft:Delete xmlns:ft="http://xmlns.4suite.org/services" path='/soap/test.com'/>
  </SOAP-ENV:Body>
</SOAP-ENV:Envelope>"""



addDocReq1 = """
<SOAP-ENV:Envelope
  xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
  SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
>
  <SOAP-ENV:Body>
    <ft:Create xmlns:ft="http://xmlns.4suite.org/services" doc-def='BASE_XML' path='/soap/test.com/doc1'>
      %s
    </ft:Create>
  </SOAP-ENV:Body>
</SOAP-ENV:Envelope>"""


getDocReq1 = """
<SOAP-ENV:Envelope
  xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
  SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
>
  <SOAP-ENV:Body>
    <ft:Fetch xmlns:ft="http://xmlns.4suite.org/services" path='/soap/test.com/doc1'/>
  </SOAP-ENV:Body>
</SOAP-ENV:Envelope>"""



def _make_soap_request(tester,body):

    req = CommonHandler.Request('/',{'Host':'127.0.0.1',
                                     'Content-Type': 'text/plain; charset="utf-8"',
                                     'SOAPAction':1,
                                     'Content-Length': str(len(body))},
                                body,
                                configFile=tester.test_data['util'].configFileName
                                )
                                
    h = SoapHandler.SoapHandler()
    resp = h.handle(req)

    dom = reader.fromString(resp.body)
    context = XPath.Context.Context(dom, processorNss={'ft': 'http://xmlns.4suite.org/services',
                                                       'SOAP-ENV':'http://schemas.xmlsoap.org/soap/envelope/'})
    body = XPath.Evaluate('//SOAP-ENV:Body',context=context)
    fault = XPath.Evaluate('//SOAP-ENV:Fault',context=context)
    if fault:
        return body,fault
    return body,None

def _parse_fault(fault):
    context = XPath.Context.Context(fault,processorNss = {'ft': 'http://xmlns.4suite.org/services'})

    fc = XPath.Evaluate('string(faultCode)',context = context)
    fs = XPath.Evaluate('string(faultString)',context = context)
    ff = XPath.Evaluate('string(faultFactor)',context = context)

    trace = XPath.Evaluate('detail/ft:traceback',context = context)
    detail = ''

    if trace:
        detail = base64.decodestring(trace[0].firstChild.data)
        
    return fc,fs,ff,detail

    
    
def _raise_fault(fault):

    fc,fs,ff,detail = _parse_fault(fault)

    print "Fault String: %s" % str(fs)
    print "Fault Factor: %s" % str(ff)
    print "Detail: %s" % str(detail)
    raise Exception(fc)
    


def _validate_document_response(tester,resp,uri,imt,src):

    context = XPath.Context.Context(resp, processorNss={'ft': 'http://xmlns.4suite.org/services',
                                                        'SOAP-ENV':'http://schemas.xmlsoap.org/soap/envelope/'})

                                                          
                                                         
    tester.compare(uri,XPath.Evaluate('string(ft:Document/@uri)',context = context))
    tester.compare(imt,XPath.Evaluate('string(ft:Document/@imt)',context = context))
    tester.compare(src,base64.decodestring(XPath.Evaluate('string(ft:Document/text())',context = context)))



    


###########
#Test Functions
###########
def prime(tester):

    tester.startTest("Prime DB")
    repo = tester.test_data['util'].getRepo()

    if repo.hasContainer('/soap'):
        repo.deleteContainer('/soap')

    container = repo.createContainer('/soap',1)
    container.setWorldWrite()
    container.setWorldRead()
    repo.txCommit()
    tester.testDone()

def init(tester):
    #Gonna do the init stuff over SOAP!!
    tester.startTest("Init")
    resp,fault = _make_soap_request(tester,fetchContainerReq1)
    if not fault:
        # Assume it is there
        resp,fault = _make_soap_request(tester,deleteTestContainer)
        if fault:
            _raise_fault(fault[0])
    resp,fault = _make_soap_request(tester,createTestContainer)
    if fault:
        _raise_fault(fault[0])
    tester.testDone()
  
def test_add_document(tester):
    #Add the doc
    tester.startTest("Create Document")
    req = addDocReq1%(base64.encodestring(xmlText))
    resp,fault = _make_soap_request(tester,req)
    if fault:
        _raise_fault(fault[0])
    _validate_document_response(tester,resp[0],'/soap/test.com/doc1','text/xml',xmlText)
    tester.testDone()
    return

def test_get_document(tester):

    tester.startTest("Get Document")
    resp,fault = _make_soap_request(tester,getDocReq1)
    if fault:
        _raise_fault(fault[0])
    _validate_document_response(tester,resp[0],'/soap/test.com/doc1','text/xml',xmlText)
    tester.testDone()


def Test(tester):
    tester.startGroup("SOAP Handler")
    prime(tester)
    init(tester)
    test_add_document(tester)
    test_get_document(tester)
    tester.groupDone()



