#include "mainWindow.h"

#include <qapplication.h>
#include <xmms/plugin.h>
#include <cstdio>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>      
#include <signal.h>
#include <error.h>
#include <errno.h>
#include <signal.h>

extern int errno;
extern const char * const sys_siglist[]; 
static int child_pid;

void signal_handler(int signo)
{
	cout << "Child caught " << sys_siglist[signo] << endl;
	cout << "Exiting child ... " << endl;
	exit(1);
}

extern "C" void init()
{
	// fork, otherwise we block in a.exec()
	child_pid = fork();
	if (!child_pid)
	{
		// child
		signal(SIGSEGV, signal_handler);
		signal(SIGPIPE, signal_handler);
		
		int argc = 0;
		char *argv[] = { "qbble" };
		QApplication a(argc, argv);
		mainWindow * mw = new mainWindow();
		mw->setCaption( "Qbble" );
		mw->show();
		a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
		a.exec();
		
		cout << "Child exiting of its own accord" << endl;
		exit(1);
		// TODO: notify XMMS here that the plugin is gone.
	}
	else
	{
		// parent
		cout << "Started qbble plugin" << endl;
	}
}

extern "C" void cleanup()
{
	cout << "Cleaning up" << endl;
	int status;
	if (!child_pid)
	{
		cout << "We got asked to cleanup something nonexistent" << endl;
	}
	else if (kill(child_pid, SIGINT) < 0)
	{
		cout << "While attempting to kill Qbble, " << strerror(errno) << endl;
	}
	else if (wait(&status) < 0)
	{
		cout << "While reaping Qbble child process, " << strerror(errno) << endl;
	}
	child_pid = 0;
}

GeneralPlugin qbble_gp =
{
    NULL,           /* handle */
    NULL,           /* filename */
    -1,         	/* xmms_session */
    "Qbble 1.1",    /* Description */
    init,
    NULL,
    NULL,
    cleanup,
};

extern "C" GeneralPlugin *get_gplugin_info(void)
{
	return &qbble_gp;
} 


