/***************************************************************************
  hopspage.h
  -------------------
  A dialog page for hops
  -------------------
  Copyright 1999-2004, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef HOPSPAGE_H
#define HOPSPAGE_H

#include "hops.h"
#include "ingredientpage.h"

class QSpinBox;
class QCheckBox;
class FixedSpinBox;

class HopsPage : public IngredientPage  {
   Q_OBJECT
public: 
    // constructor
    HopsPage(Model *model, View *view, Controller *controller,
             const char *name);
    // destructor
    ~HopsPage();

    // document has changed
    void documentChanged();

private slots:
    // add clicked
    void addHops();    
    // remove clicked
    void removeHops();    
    // apply clicked
    void applyHops();    
    // update the widgets in the entry area
    void updateEntryItems(const QString &name);
    // an ingredient was selected
    void itemSelected(QListViewItem *item);

private:
    // update the list view
    void updateListView();
    
private:
    QLabel* formlabel_;
    QComboBox* formcombo_;
    QLabel* alphalabel_;
    FixedSpinBox* alphaspin_;
    QLabel* timelabel_;
    QSpinBox* timespin_;
    HopsListItem* currentitem_;
};

#endif // HOPSPAGE_H
