#include "qsstvglobal.h"
#include "recorder.h"
#include <qapplication.h>
#include <qfiledlg.h>
#include <qmessagebox.h>
#include "filefunc.h"
#include "dspfunc.h"

recorder::recorder(QWidget* parent,const char* name): recorderForm (parent, name,TRUE)
{
//	dsp->setRecording(TRUE);
	dsp->initDSP(isamplingrate);
}

recorder::~recorder()
{
//	dsp->setRecording(FALSE);
}

bool recorder::saveFile()
{
  QDir stemp;
  QFileInfo t;
  cancelReq=FALSE;
  stemp.setPath(configFile.readOption("SoundDir"));
  getFileName(foutput,stemp,"*.raw");
  t.setFile(foutput.name());
  changeExtension(t,"raw",FALSE); // add extension if there is none
	foutput.setName(t.filePath());
  if(!foutput.open(IO_Raw| IO_WriteOnly|IO_Truncate))
    {
      return FALSE;
    }
	exec();
  return TRUE;
}


void recorder::slotStartClicked(bool b)
{
	short int sample;
  QString errorstring;
  if (b)
		{
    	sscanf(timeLineEdit->text(),"%u",&recordingTime);
    	numberOfSamples=recordingTime*isamplingrate;
			if(!dsp->startReceive())
				{
					foutput.close();
					done(0);
				}
			else
				{
					while((numberOfSamples-->0)&&(cancelReq==FALSE))
						{
							while(!dsp->getRawData(sample))
								{
									qApp->processEvents(3);
								}
							foutput.writeBlock((char *)&sample,sizeof(short int));
						}
					foutput.close();
					if(cancelReq)
						{
	  					foutput.remove();
						}
					done(0);
				}
		}
	else
    {
     numberOfSamples=0;
    }		 
}

void recorder::slotCancelClicked()
{
  if (startButton->isOn())
    {  
      cancelReq=TRUE;
      startButton->setOn(FALSE);
    }
else
  {
    foutput.remove();
    done(0);
  }
}




