#ifndef race_objects
#define race_objects

#include "tile_enums.h"
#include "camera.h"
#include "sound_controller.h"

// TODO: puke... need I say more?

class Car
{
 public:
	Car( float x, float y, int id );
	virtual ~Car() { return; }

	virtual bool is_player()=0;
	virtual bool is_ai()=0;

	virtual void update(float)=0;
	virtual void show(int,int)=0;

	float get_distance_to_next_attractor(int,int);

	short points, last_race_points;	
	char next_race_start_pos;
	int id;

	char rot_count;
	float smooth_rot_x[10];
	float smooth_rot_y[10];

	float time_elapsed;
	float gravity_velocity;

	float dist;
	float old_dist;
	
	float best_lap;
	
	int control_points_passed;
	int control_points_passed_total;  // used for pos counting
	
	RaceCamera camera;
	SoundController sound_controller;
	
	bool end_race_ok;
	
	bool under_bridge;
	
	int	Frame;
	float rot_x, rot_y;
	
	Items last_item;
	
	float x, y, z;
	
	float speed;
	float accel;            // acceleration 
	float max_speed;        // max speed depending on the terrain 
	
	int	position;           // position in goal                 
	
	char angle_difference;
	
	int	angle;              // movement angle. 0...31 
	int	wanted_angle;       // the car should move in this direction 
	int angleDifference;    // difference between angle (move dir) and wanted_angle 
	int	c_angle;            // (help value) not "collision angle" angles are exchanged in collision between cars.
	int	slideDirection;	    // clockwise or not
	bool sliding;           // if true: slows down speed and disables acceleration 
	
	int skid_mark_draw_time; // no need to draw skid's every frame
	
	int	bad_design_counter;	// creates sliding effect 
	
	double laptime_start;   // well...
	bool checktime;	        // check the laptime if true 
	
	int	laps;               // laps completed
	int	p_num;				// player number (1 or 2)
	
	bool bounced_from_wall;	// wont get stuck to "walls"
	bool in_goal;           // 

	bool dust;              // add more dust to the list
	unsigned int dust_time;
	unsigned int last_dust_time;
	
	float cp1_x, cp1_y;
	
	float dx, dy;
	
	char bounced_from;
	
	float update_dir_timer;
	
	virtual void update_frame(int)=0;
	
	float get_x() { return x; }
	float get_y() { return y; }
	float get_cp1_x() { return cp1_x; }
	float get_cp1_y() { return cp1_y; }
	float get_dx() { return dx; }
	float get_dy() { return dy; }
	
	int get_frame() { return Frame; }
	
	int get_wanted_angle() {return wanted_angle;}
	
	void set_pos(float _x, float _y);
	
	float get_speed() { return speed; }
	int get_angle() { return angle; }
	
	int get_lap() { return laps; }
	int get_p_num() { return p_num; }
	int get_position() { return position; }
	
	void reset();      // reset all values except points, car additions... 
	void reset_all();  // reset everything 
	void reset_shop_one_race_stuff();
	
	void move();  // called from race.cpp 
	void turn();  // called from player or ai update().
	
	void set_angle(int _ang) {angle = _ang;}
	
    void bounce_from_walls();
    void bounce_from_objects();
	
	bool get_rotate_dir(int,int);

// the functions called from turn()  

	virtual void update_wanted_dir()=0;
	virtual void update_extras()=0;  // rocket engine, tires etc. (shop stuff)
	void update_move_dir();
	void update_check_points();
	void check_current_tile();
	void update_sound();

// the functions called from check_current_tile() 

	virtual void update_object_speed()=0;
	void update_speed();
	void check_bridge();
	void check_ramp();
	void check_check_points();
	void add_dust();
	void collide();

// the functions called from set_move_dir() 

	char calc_angle_difference();
	void calc_slide_direction();

// these are called from somewhere else 

	void terrain_rotate(); // rotate car so it follow terrain.
	bool hit_check();
	virtual void reset_special()=0; // set ai attr. to first

	virtual void set_move_delta( float, float ); // hit check

	virtual void draw_speed_meter() {;}
};

#endif
