#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include "emitter_controller.h"
#include "pixel.h"
#include "emitter.h"
#include "particle.h"
#include "emit_config.h"

Emitter::Emitter(int x, int y, float angle, Pixel pixel, EmitterController *_parent )
{
	this->x = x;
	this->y = y;
	this->angle = angle;
	this->pixel = pixel;

	parent = _parent;

	add_timer = 0;
}

void Emitter::add_particle()
{
	if( parent->active != true )
  		return;

	if( particles.size() < 20
	   && CL_System::get_time() - add_timer > EmitConfig::particle_add_time )
	{
		float scr_x = x;
		float scr_y = y;
	
		particles.push_back( new Particle( scr_x, scr_y, angle, pixel ) );
		
		add_timer = CL_System::get_time();
	}
}

void Emitter::update( float time_elapsed )
{
	add_particle();
	
	std::vector<Particle*>::iterator it;
	
	for( it = particles.begin();
		 it != particles.end(); 
		 it++ )
	{
		(*it)->update( time_elapsed );
	
		if( (*it)->destroy )
	  	{
			delete (*it);
			it = particles.erase( it );
			if( it == particles.end() )
		  		break;
		}
	}
}


