
#include <ClanLib/core.h>
#include <vector>
#include <cstdio>
#include <cstdlib>

#include "face.h"
#include "race_text.h"
#include "h3d_loader.h"

std::vector<Face> H3DLoader::load( CL_String filename )
{
	std::vector<Face> faces;
	
	CL_InputSourceProvider *input = CL_InputSourceProvider::create_file_provider("");
	CL_InputSource *file = input->open_source( filename.get_string() );
	
	CL_String line = RaceText::read_line(file);
	
	if( line != "##_h3d_" )
	{
		std::cout << "file not a valid .h3d file (header doesn't match)" << std::endl;
	}
	else
	{
		bool a = true;
//		bool read_g_color = false;
		int linenum = 1;

		while( a )
		{
			line = RaceText::read_line(file);
			linenum++;
			
			if( atoi(line.get_string()) == 9999 )
			{
				 a = false;
			}
			else
			{
				double r[3], g[3], b[3];    // colors
				double nx[3], ny[3], nz[3]; // normals
				double u[3], v[3];          // texture coordinates
				double x[3], y[3], z[3];    // vertices
				bool shade_type;
				bool has_tex;
				
				int i = 0;

				// cout << "loading colors, linenum: " << linenum << endl;
				// vertex colors
				for( i=0; i<3; i++ )
				{
					r[i] = atof(line.get_string()); line = RaceText::read_line(file);
					g[i] = atof(line.get_string()); line = RaceText::read_line(file);
					b[i] = atof(line.get_string()); line = RaceText::read_line(file);
					linenum+=3;
				}
				// cout << "loading normals, linenum: " << linenum << endl;
				
				// normals
				for( i=0; i<3; i++ )
				{
					nx[i] = atof(line.get_string()); line = RaceText::read_line(file);
					ny[i] = atof(line.get_string()); line = RaceText::read_line(file);
					nz[i] = atof(line.get_string()); line = RaceText::read_line(file);
					linenum+=3;
				}
				
				has_tex = atoi(line.get_string()); line = RaceText::read_line(file);
				linenum++;

				// texture coordinates
				if( has_tex != 0 )
				{
					//cout << "loading texture coords, linenum: " << linenum << endl;
					for( i=0; i<3; i++ )
					{
						u[i] = atof(line.get_string()); line = RaceText::read_line(file);
						v[i] = atof(line.get_string()); line = RaceText::read_line(file);
						linenum+=2;
					}
				}
			   
				//cout << "loading vertices, linenum: " << linenum << endl;
				// vertices
				for( i=0; i<3; i++ )
				{
					x[i] = atof(line.get_string()); line = RaceText::read_line(file);
					y[i] = atof(line.get_string()); line = RaceText::read_line(file);
					z[i] = atof(line.get_string()); line = RaceText::read_line(file);
					linenum+=3;
				}

				// shade type
			    shade_type = atoi(line);

				Face tmp_face(  r[0], g[0], b[0],
								r[1], g[1], b[1],
								r[2], g[2], b[2],
								nx[0], ny[0], nz[0],
								nx[1], ny[1], nz[1],
								nx[2], ny[2], nz[2],
								u[0], u[1], u[2],
								v[0], v[1], v[2],
								x[0], y[0], z[0],
								x[1], y[1], z[1],
								x[2], y[2], z[2],
								shade_type, has_tex );

				faces.push_back( tmp_face );

				// cout << "------ next face -------- line: " << linenum << endl;
			}
		}
	}

	return faces;
}
