#ifndef race_map_object_house
#define race_map_object_house

class Object3D;
class Texture;

class House
{
 public:
	static void draw( int x, int y, float z, int item );
	
	static void load( CL_ResourceManager &res );
	static void unload();

	static void modify_base( float x, float y, int item, float r, CL_Canvas *canvas );
	
	static void load_1x1( CL_ResourceManager &res );
	static void load_2x2( CL_ResourceManager &res );
	static void load_3x5( CL_ResourceManager &res );
	static void load_5x3( CL_ResourceManager &res );
	static void load_5x5( CL_ResourceManager &res );
	
	static std::vector<Object3D*> house_1x1;
	static std::vector<Texture>  house_1x1_tex;
	
	static std::vector<Object3D*> house_2x2;
	static std::vector<Texture>  house_2x2_tex;
	
	static std::vector<Object3D*> house_5x3;
	static std::vector<Texture>  house_5x3_tex;
	
	static std::vector<Object3D*> house_3x5;
	static std::vector<Texture>  house_3x5_tex;
	
	static std::vector<Object3D*> house_5x5;
	static std::vector<Texture>  house_5x5_tex;
};

#endif
