#ifndef racegl_object_3d
#define racegl_object_3d

#include "face.h"

class Object3D
{
 public:
	Object3D( CL_String filename, bool set_color=true );

	static Object3D *load( std::string res_id, CL_ResourceManager *res, bool set_color=true );

	void draw();
	void make_display_list();

	float get_max_x() {return max_x;}
	float get_max_y() {return max_y;}
	float get_max_z() {return max_z;}
	float get_min_x() {return min_x;}
	float get_min_y() {return min_y;}
	float get_min_z() {return min_z;}

 private:
	std::vector<Face> faces;

	float max_x, min_x;
	float max_y, min_y;
	float max_z, min_z;

	bool set_color;

	unsigned int d_list;
};

#endif
