#ifndef race_player
#define race_player

class Car;

class Car_Player : public Car
{
 public:
	Car_Player(float x, float y, char id, short p_num );
	~Car_Player();

	virtual void show(int center_x, int center_y );
	virtual void update(float);

	virtual bool is_player() { return true; }
	virtual bool is_ai() { return false; }

	virtual void update_wanted_dir();
	virtual void reset_special();
	
	virtual void update_frame(int){}

	virtual void update_object_speed();
	int get_current_position();

	void check_out_of_map();

	void shoot();
	void update_sound();
	void play_engine_start();
	
	virtual void draw_speed_meter();

	virtual void update_extras();

	bool start;
	bool draw_start_highlight;
	int start_highlight_time;

	bool out_of_map;
	float out_of_map_start_time;

	int end_position; // once player has reached goal this value is showed by
	                  // the position counter.
};

#endif

