#include <ClanLib/gl.h>
#include <ClanLib/display.h>

#include "texture.h"

std::vector<GLuint> Texture::texture_handles;
unsigned short Texture::num_textures = 0;

Texture::Texture()
{
	surface = NULL;
	provider = NULL;
}

Texture::~Texture()
{
/*	if( surface != NULL )
	{
		delete surface;
		surface = NULL;
	}*/
}

Texture::Texture( CL_Surface *surface, bool alpha )
{
	this->surface = surface;
	
	provider = surface->get_provider();
	provider->lock();
	
	int DEPTH = 0;
	int BPP = 3;
	
	if( provider->get_depth() == 24 )
	{
		DEPTH = GL_RGB;

		// swap from BGR to RGB
		unsigned char *data = (unsigned char*)provider->get_data();
		for( unsigned int y=0;y<surface->get_height(); y++ )
		{
			for( unsigned int x=0;x<surface->get_width(); x++ )
			{
				char pixel[3] = {data[0], data[1], data[2] };
				data[0]=pixel[2];
				data[1]=pixel[1];
				data[2]=pixel[0];
				data += 3;
			}
		}	   
	}
   
	if( provider->get_depth() == 32 )
	{
		DEPTH = GL_RGBA;
		if( alpha ) BPP = 4;

		// swap from ARGB to RGBA
		unsigned char *data = (unsigned char*)provider->get_data();
		for( unsigned int y=0;y<surface->get_height(); y++ )
		{
			for( unsigned int x=0;x<surface->get_width(); x++ )
			{
				char pixel[4] = {data[0], data[1], data[2], data[3] };
				data[0]=pixel[3];
				data[1]=pixel[2];
				data[2]=pixel[1];
				data[3]=pixel[0];
				data += 4;
			}
		}	   
	}
   

	GLuint tmp_tex_handle = 0;
	
	glGenTextures(1, &tmp_tex_handle );
	glBindTexture(GL_TEXTURE_2D, tmp_tex_handle );
	glTexImage2D(GL_TEXTURE_2D, 0, BPP, surface->get_width(), surface->get_height(), 0,
				 DEPTH, GL_UNSIGNED_BYTE, provider->get_data());

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	texture_handles.push_back(tmp_tex_handle);
	id = num_textures;
	num_textures++;
}

